SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_rom_frete_parc_cli_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _rom_frete record;
    _id_veic integer;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'ROM_FRETE.CLI' and
            id_org = old.id_rom_frete and
            id_org_item = old.id_rom_frete_parc_cli;
            -- org = 'ROM_FRETE.CLI.' || old.id_rom_frete || '.' || old.id_rom_frete_parc_cli;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
    
        select * into _rom_frete
        from tb_rom_frete
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete;
    
        _id_ct := nextval('sq_ct');
        
        select id_veic into _id_veic
        from tb_rom_frete_item
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete
        order by
            id_rom_frete_item
        limit 1;
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             id_plano_ct,
             id_rom_frete, id_veic,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _rom_frete.id_tom, new.id_rom_frete, new.id_rom_frete_parc_cli, new.qtd_parc,
             _rom_frete.dt_lanc, new.dt_venc, new.vl_parc, 'P', 
             'ROM_FRETE.CLI.' || new.id_rom_frete || '.' || new.id_rom_frete_parc_cli, 'ROM_FRETE.CLI', new.id_rom_frete, new.id_rom_frete_parc_cli, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             new.id_plano_ct,
             new.id_rom_frete, _id_veic,
             new.vl_parc, 0, 0, 0, 0, 
             _rom_frete.id_usr_ult_alt, _rom_frete.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_rom_frete_item_parc_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _rom_frete_item record;
    _rom_frete record;
    _descr varchar;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'ROM_FRETE.ITEM' and
            id_org = old.id_rom_frete and
            id_org_item = old.id_rom_frete_item and
            org = 'ROM_FRETE.ITEM.' || old.id_rom_frete || '.' || old.id_rom_frete_item || '.' || old.id_rom_frete_item_parc;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = 'DUP'
        limit 1;
    
        select
            tb_rom_frete.*,
            trim(substring(tb_part_tom.nome, 1, 15)) as nome_tom,
            trim(substring(tb_part_dest.nome, 1, 15)) as nome_dest
        into _rom_frete
        from tb_rom_frete
        left outer join tb_part as tb_part_tom on
            (tb_rom_frete.id_tom = tb_part_tom.id_part)
        left outer join tb_part as tb_part_dest on
            (tb_rom_frete.id_dest = tb_part_dest.id_part)
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete;
            
        select * into _rom_frete_item
        from tb_rom_frete_item
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete and
            id_rom_frete_item = new.id_rom_frete_item;
    
        _id_ct := nextval('sq_ct');
        
        _descr := _rom_frete.nome_tom || ' / ' || _rom_frete.nome_dest || ' R. ' || _rom_frete.id_rom_frete;-- || ' D. ' || _rom_frete.vl_qtd;
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             obs,
             id_rom_frete, id_veic,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _rom_frete_item.id_colab, new.id_rom_frete, new.parc, new.qtd_parc,
             _rom_frete.dt_lanc, new.dt_venc, new.vl_parc, 'P', 
             'ROM_FRETE.ITEM.' || new.id_rom_frete || '.' || new.id_rom_frete_item || '.' || new.id_rom_frete_item_parc, 'ROM_FRETE.ITEM', new.id_rom_frete, new.id_rom_frete_item, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             _descr,
             new.id_rom_frete, _rom_frete_item.id_veic,
             new.vl_parc, 0, 0, 0, 0, 
             _rom_frete.id_usr_ult_alt, _rom_frete.dt_hr_ult_alt);

    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_req_colab_parc_forn_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _req_colab record;
BEGIN
    select * into _op_fnc
    from tb_op_fnc
    where
        tp_op_fnc = 'DUP'
    limit 1;
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'REQ_COLAB.FORN' and
            id_org = old.id_req_colab and
            id_org_item = old.id_req_colab_parc_forn;
            -- org = 'REQ_COLAB.FORN.' || old.id_req_colab || '.' || old.id_req_colab_parc_forn;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _req_colab
        from tb_req_colab
        where
            id_emp = new.id_emp and
            id_req_colab = new.id_req_colab;
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             obs,
             id_rom_frete, id_veic,
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             id_plano_ct, id_cnt_cst,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _req_colab.id_forn, new.id_req_colab, new.id_req_colab_parc_forn, new.qtd_parc,
             _req_colab.dt_req_colab, new.dt_venc, new.vl_parc, 'P', 
             new.obs,
             _req_colab.id_rom_frete, _req_colab.id_veic,
             'REQ_COLAB.FORN.' || new.id_req_colab || '.' || new.id_req_colab_parc_forn, 'REQ_COLAB.FORN', new.id_req_colab, new.id_req_colab_parc_forn, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             new.id_plano_ct, new.id_cnt_cst,
             new.vl_parc, 0, 0, 0, 0, 
             _req_colab.id_usr_ult_alt, _req_colab.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_req_colab_parc_colab_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _req_colab record;
    _descr varchar;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'REQ_COLAB.COLAB' and
            id_org = old.id_req_colab and
            id_org_item = old.id_req_colab_parc_colab;
            -- org = 'REQ_COLAB.COLAB.' || old.id_req_colab || '.' || old.id_req_colab_parc_colab;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = 'DUP'
        limit 1;
    
        select 
            tb_req_colab.*,
            tb_part.nome as nome_forn
        into _req_colab
        from tb_req_colab
        left outer join tb_part on
            (tb_req_colab.id_forn = tb_part.id_part)
        where
            id_emp = new.id_emp and
            id_req_colab = new.id_req_colab;
    
        _id_ct := nextval('sq_ct');
        
        _descr := 'REQ ' || _req_colab.id_req_colab || ' ' || _req_colab.nome_forn;
        
        if (new.qtd_parc > 1) then
            _descr := _descr || ' ' || new.id_req_colab_parc_colab || '/' || new.qtd_parc;
        end if;
        
        if (coalesce(new.obs, '') <> '') then
            _descr := _descr || ' ' || new.obs;
        end if; 
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             obs, id_veic,
             id_rom_frete,
             id_plano_ct, id_cnt_cst,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _req_colab.id_colab, new.id_req_colab, new.id_req_colab_parc_colab, new.qtd_parc,
             _req_colab.dt_req_colab, new.dt_venc, new.vl_parc, 'P', 
             'REQ_COLAB.COLAB.' || new.id_req_colab || '.' || new.id_req_colab_parc_colab, 'REQ_COLAB.COLAB', new.id_req_colab, new.id_req_colab_parc_colab, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             _descr, _req_colab.id_veic,
             _req_colab.id_rom_frete,
             new.id_plano_ct, new.id_cnt_cst,
             new.vl_parc, 0, 0, 0, 0, 
             _req_colab.id_usr_ult_alt, _req_colab.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_nf_item
  ALTER COLUMN vl_qtd_com TYPE DOUBLE PRECISION;

ALTER TABLE public.tb_nf_item
  ALTER COLUMN vl_unt_com TYPE DOUBLE PRECISION;

ALTER TABLE public.tb_nf_item
  ALTER COLUMN vl_qtd_trib TYPE DOUBLE PRECISION;

ALTER TABLE public.tb_nf_item
  ALTER COLUMN vl_unt_trib TYPE DOUBLE PRECISION;

ALTER TABLE public.tb_rom_frete_item
  ADD COLUMN vl_km_i NUMERIC(12,2);

ALTER TABLE public.tb_rom_frete_item
  ADD COLUMN vl_km_f NUMERIC(12,2);

ALTER TABLE public.tb_ct
  ADD COLUMN id_rom_frete INTEGER;

