CREATE OR REPLACE VIEW public.vw_mov_plano_ct (
    id_emp,
    id_mov_plano_ct,
    org,
    tp_org,
    id_org,
    id_org_item,
    id_plano_ct,
    dt_lanc,
    descr,
    vl_lanc)
AS
        (        (         SELECT tb_bx_ct.id_emp, 
                            (('BX_CT.'::text || tb_bx_ct.id_bx_ct) || '.'::text) || tb_ct.id_ct AS id_mov_plano_ct, 
                            (('BX_CT.'::text || tb_bx_ct.id_bx_ct) || '.'::text) || tb_ct.id_ct AS org, 
                            'BX_CT'::text AS tp_org, 
                            tb_bx_ct.id_bx_ct AS id_org, 
                            tb_ct.id_ct AS id_org_item, tb_ct.id_plano_ct, 
                            tb_bx_ct.dt_bx AS dt_lanc, tb_part.nome AS descr, 
                            tb_bx_ct__ct.vl_quit AS vl_lanc
                           FROM tb_bx_ct
                      JOIN tb_bx_ct__ct ON tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp AND tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct
                 JOIN tb_ct ON tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp AND tb_bx_ct__ct.id_ct = tb_ct.id_ct
            JOIN tb_plano_ct _plano_ct ON tb_ct.id_plano_ct::text = _plano_ct.id_plano_ct::text
       JOIN tb_part ON tb_ct.id_part = tb_part.id_part
                UNION ALL 
                         SELECT tb_mov_bnc.id_emp, 
                            'MOV_BNC.'::text || tb_mov_bnc.id_mov_bnc AS id_mov_plano_ct, 
                            'MOV_BNC.'::text || tb_mov_bnc.id_mov_bnc AS org, 
                            'MOV_BNC'::text AS tp_org, 
                            tb_mov_bnc.id_mov_bnc AS id_org, 
                            NULL::integer AS id_org_item, 
                            tb_mov_bnc.id_plano_ct, 
                            tb_mov_bnc.dt_emis AS dt_lanc, 
                            COALESCE(tb_part.nome::text || ' - '::text, ''::text) || tb_mov_bnc.descr::text AS descr, 
                            tb_mov_bnc.vl_lanc
                           FROM tb_mov_bnc
                      JOIN tb_plano_ct _plano_ct ON tb_mov_bnc.id_plano_ct::text = _plano_ct.id_plano_ct::text
                 LEFT JOIN tb_part ON tb_mov_bnc.id_part = tb_part.id_part
                WHERE NOT COALESCE(tb_mov_bnc.org, ''::character varying)::text ~~ 'BX_CT.%'::text)
        UNION ALL 
                 SELECT tb_mov_fnc.id_emp, 
                    'MOV_FNC.'::text || tb_mov_fnc.id_mov_fnc AS id_mov_plano_ct, 
                    'MOV_FNC.'::text || tb_mov_fnc.id_mov_fnc AS org, 
                    'MOV_FNC'::text AS tp_org, tb_mov_fnc.id_mov_fnc AS id_org, 
                    NULL::integer AS id_org_item, tb_mov_fnc.id_plano_ct, 
                    tb_mov_fnc.dt_lanc, tb_mov_fnc.descr, tb_mov_fnc.vl_lanc
                   FROM tb_mov_fnc
              JOIN tb_plano_ct _plano_ct ON tb_mov_fnc.id_plano_ct::text = _plano_ct.id_plano_ct::text
             WHERE tb_mov_fnc.org IS NULL)
UNION ALL 
         SELECT tb_vnd.id_emp, 
            (('VND.'::text || tb_vnd.id_vnd) || '.'::text) || tb_vnd_parc.id_vnd_parc AS id_mov_plano_ct, 
            (('VND.'::text || tb_vnd.id_vnd) || '.'::text) || tb_vnd_parc.id_vnd_parc AS org, 
            'VND'::text AS tp_org, tb_vnd.id_vnd AS id_org, 
            tb_vnd_parc.id_vnd_parc AS id_org_item, 
            tb_emp_cnf.val AS id_plano_ct, tb_vnd.dt_vnd AS dt_lanc, 
            tb_part.nome AS descr, tb_vnd_parc.vl_parc AS vl_lanc
           FROM tb_vnd
      JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd
   JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
   JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
   LEFT JOIN tb_emp_cnf ON tb_vnd.id_emp = tb_emp_cnf.id_emp AND trunc((tb_emp_cnf.id_cnf / 100)::double precision) = 161::double precision AND (tb_emp_cnf.id_cnf - 16100) = tb_op_fnc.id_op_fnc
  WHERE COALESCE(tb_vnd.canc, false) = false;

