SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_req_colab_parc_colab_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _req_colab record;
    _descr varchar;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'REQ_COLAB.COLAB.' || old.id_req_colab || '.' || old.id_req_colab_parc_colab;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = 'DUP'
        limit 1;
    
        select 
            tb_req_colab.*,
            tb_part.nome as nome_forn
        into _req_colab
        from tb_req_colab
        left outer join tb_part on
            (tb_req_colab.id_forn = tb_part.id_part)
        where
            id_emp = new.id_emp and
            id_req_colab = new.id_req_colab;
    
        _id_ct := nextval('sq_ct');
        
        _descr := 'REQ ' || _req_colab.id_req_colab || ' ' || _req_colab.nome_forn;
        
        if (new.qtd_parc > 1) then
            _descr := _descr || ' ' || new.id_req_colab_parc_colab || '/' || new.qtd_parc;
        end if;
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, id_op_fnc, vl_quit, vl_rest, 
             obs, id_veic,
             id_plano_ct, id_cnt_cst,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _req_colab.id_colab, new.id_req_colab, new.id_req_colab_parc_colab, new.qtd_parc,
             _req_colab.dt_req_colab, new.dt_venc, new.vl_parc, 'P', 
             'REQ_COLAB.COLAB.' || new.id_req_colab || '.' || new.id_req_colab_parc_colab, _op_fnc.id_op_fnc, 0, new.vl_parc, 
             _descr, _req_colab.id_veic,
             _req_colab.id_plano_ct, _req_colab.id_cnt_cst,
             new.vl_parc, 0, 0, 0, 0, 
             _req_colab.id_usr_ult_alt, _req_colab.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_contr_frete_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
    
    _id_ct integer;
    _num integer;
    _cte record;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'INSERT') then
            new.num := fc_get_num_contr_frete(new.id_emp);
        end if;
        
        if (tg_op = 'DELETE' or (tg_op = 'UPDATE' and (new.sit = 'P' or coalesce(new.sit, '') = ''))) and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                org = 'CONTR_FRETE.' || old.id_contr_frete;
            
        end if;
        
        if (tg_op = 'INSERT' or (tg_op = 'UPDATE' and (new.sit = 'P' or coalesce(new.sit, '') = ''))) and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            limit 1;
            
            select * into _cte
            from tb_cte
            where
                id_emp = new.id_emp and
                id_cte = new.id_cte;
            
            _id_ct := nextval('sq_ct');
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                 dt_emis, dt_venc, vl_ct, stat, id_veic,
                 org, id_op_fnc, vl_quit, vl_rest, 
                 vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                 id_usr_ult_alt, dt_hr_ult_alt)
            values
                (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, new.id_part, new.num, 1, 1,
                 new.dt_emis, new.dt_emis, new.vl_tot, 'P', _cte.id_veic,
                 'CONTR_FRETE.' || new.id_contr_frete, _op_fnc.id_op_fnc, 0, new.vl_tot, 
                 new.vl_tot, 0, 0, 0, 0, 
                 new.id_usr_ult_alt, new.dt_hr_ult_alt);
                
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

