SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _ct record;
    _op varchar;
    _descr varchar;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') then
        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'CT_PAGTO.' || old.id_ct || '.' || old.id_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        select * into _ct
        from tb_ct
        where
            id_emp = new.id_emp and
            id_ct = new.id_ct;
        
        if (_ct.tp_ct = 'R') then
            _op := 'D';
        else
            _op := 'C';
        end if;
        
        
        _descr := '';
        
        if (_ct.org like 'MOV_COLAB.ADTO%') then
            _descr := 'ADTO N° ' || _ct.id_ct;
        end if;
        
        if (new.descr is not null) then
            _descr := _descr || ' - ' || new.descr;
        end if;
        
        
        
        insert into tb_mov_bnc
            (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
             org, id_org,
             id_part, sit_conc,
             id_usr_ult_alt, dt_hr_ult_alt,
             id_ct_ctb_d, id_ct_ctb_c,
             id_op_fnc)
        values
            (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_pagto, new.dt_pagto, new.nr_doc, _op, new.vl_pagto, _descr, false,
             'CT_PAGTO.' || new.id_ct || '.' || new.id_ct_pagto, new.id_ct,
             _ct.id_part, 'PEND',
             new.id_usr_ult_alt, new.dt_hr_ult_alt,
             _ct.id_ct_ctb_d, _ct.id_ct_ctb_c,
             new.id_op_fnc);
    end if;
                     
                     
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    else
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;    
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org, id_op_fnc, vl_quit, vl_rest,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_op_fnc, 0, new.vl_pagto,
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        _descr_part := '';
        
        if (_bx_ct.op = 'A') then
            _descr := 'ACERTO N° ' || _bx_ct.num_doc;
            
            if (new.obs is not null) then
                _descr_part := ' - ' || new.obs;
            end if;
        else
            select nome into _descr_part
            from tb_part
            where
                id_part = _bx_ct.id_part;
                
            if (_descr_part is null) then
                _descr_part := '';
            else
                _descr_part := ' ' || _descr_part;
            end if;
            
            if (new.obs is not null) then
                _descr_part := _descr_part || ' ' || new.obs;
            end if;
            
            _descr := ifthen(_bx_ct.tp_bx = 'R', 'REC ', 'PAG ');
        end if;
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND',
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c,
                 new.id_op_fnc);
        
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_part_doc
  ALTER COLUMN num TYPE VARCHAR(100) COLLATE pg_catalog."default";

ALTER TABLE public.tb_part
  ALTER COLUMN tit_eleit TYPE VARCHAR(50) COLLATE pg_catalog."default";

