SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
    
    _id_plano_ct varchar;
    
    _ct record;
    _id_ct integer;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
            
            delete from tb_mov_bnc
            where 
                id_emp = old.id_emp and
                org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select * into _vnd
            from tb_vnd
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                
                
            select tb_nat_op.* into _nat_op
            from tb_vnd
            join tb_nat_op on
                (tb_vnd.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_vnd.id_emp = new.id_emp and
                tb_vnd.id_vnd = new.id_vnd;
                    
            _gera_fin := _nat_op.op like '%[VND__GER_FIN]%';

            if (_op_fnc.gera_ct and _gera_fin) then
                    
                _nr_doc := new.nr_doc;
                    
                if (_op_fnc.tp_op_fnc = 'DUP' and coalesce(_nr_doc, '') = '') then
                    _nr_doc := new.id_vnd || '/' || new.nr_parc;
                end if;
                
                _id_plano_ct := fc_get_emp_cnf(new.id_emp, 16200);
                
                if (_id_plano_ct = '') then
                    _id_plano_ct := null;
                end if;
                
                _id_ct := nextval('sq_ct');
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct,
                     vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_veic)
                values
                    (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, new.id_op_fnc, 0, new.vl_parc, 
                     _id_plano_ct,
                     new.vl_sub_tot, coalesce(new.vl_perc_desc, 0), coalesce(new.vl_desc, 0), coalesce(new.vl_perc_acr, 0), coalesce(new.vl_acr, 0), 
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     _vnd.id_veic);
                
                
                if (_op_fnc.tp_op_fnc = 'BLT') then
                    select * into _ct
                    from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_ct = _id_ct;
                        
                    new.nr_doc := _ct.nr_doc;
                    
--                    raise notice '12345 Boleto %', new.nr_doc;
                    
                elsif (_op_fnc.tp_op_fnc = 'DUP') then
                    new.nr_doc := cast(_id_ct as varchar);
                    
--                    raise notice '12345 Duplicata %', new.nr_doc;
                    
                end if;
            end if;
                
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd,
                     _vnd.id_cli, 'PEND',
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     new.id_op_fnc);
            end if;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
begin
    _app_con := fc_app_con();

    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
        
   end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select 
                tb_nf.tp_emis as tp_emis_nf,
                tb_nat_op.* 
            into 
                _nat_op
            from tb_nf
            join tb_nat_op on
                (tb_nf.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_nf.id_emp = new.id_emp and
                tb_nf.id_nf = new.id_nf;
                
            _gera_fin :=
                (_nat_op.tp_emis_nf = '[P]' and _nat_op.op like '%[NF_EMT__GER_FIN]%') or
                (_nat_op.tp_emis_nf = '[T]' and _nat_op.op like '%[NF_REC__GER_FIN]%');
                
                
            if (_op_fnc.gera_ct and _gera_fin) then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, 
                     id_cnt_bnc, org,
                     obs, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, _nf.id_part_emt, new.nr_doc, new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     new.id_cnt_bnc, 'NF.' || new.id_nf || '.' || new.id_nf_parc,
                     'NF ' || _nf.num || ' ' || _op_fnc.descr, new.id_op_fnc, 0, new.vl_parc, 
                     new.id_plano_ct,
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_plano_ct,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _nf.dt_op, new.dt_venc, new.nr_doc, 'D', new.vl_parc, 'NF ' || _nf.num || ' ' || _op_fnc.descr, false,
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, _nf.id_nf,
                     _nf.id_part_emt, 'PEND',
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     new.id_plano_ct,
                     new.id_op_fnc);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_fnc_bf (
)
RETURNS trigger AS
$body$
begin
    if ((tg_op = 'UPDATE') and (old.op = 'T')) or (tg_op = 'DELETE') then
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'MOV_FNC.' || old.id_mov_fnc;
                
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'MOV_FNC.' || old.id_mov_fnc;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        if (new.op = 'T') and (new.dst = 'C') and (coalesce(new.id_dst, 0) > 0) then
            insert into tb_mov_fnc
                (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc, 
                 doc, descr, op, vl_lanc, 
                 org, id_org, id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_fnc'), new.id_dst, new.id_usr, new.dt_lanc, new.hr_lanc,
                 new.doc, new.descr, 'C', new.vl_lanc, 'MOV_FNC.' || new.id_mov_fnc, new.id_mov_fnc, new.id_op_fnc);
        end if;
        
        if (new.op = 'T') and (new.dst = 'B') and (coalesce(new.id_dst, 0) > 0) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc,
                 nr_doc, descr, op, vl_lanc, conc,
                 org, id_org,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_dst, new.dt_lanc, new.dt_lanc, 
                 new.doc, new.descr, 'C', new.vl_lanc, false, 
                 'MOV_FNC.' || new.id_mov_fnc, new.id_mov_fnc,
                 new.id_usr_ult_alt, new.dt_hr_ult_alt,
                 new.id_op_fnc);
        end if;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_cx_af (
)
RETURNS trigger AS
$body$
declare
    _descr_cx varchar;
    _descr_usr varchar;
begin
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        if (old.id_mov_cx is not null) then
            delete from tb_mov_bnc
            where
                id_emp = old.id_emp and
                org = 'MOV_CX.' || old.id_mov_cx;
                
            
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        if (new.id_cnt_bnc is not null) and (new.vl_din_sld + new.vl_ch_sld > 0) then

            select nome into _descr_usr
            from tb_usr
            where
                id_usr = new.id_usr;
            
            select descr into _descr_cx
            from tb_cx
            where
                id_emp = new.id_emp and
                id_cx = new.id_cx;
                
            
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc,
                 descr, op, vl_lanc, conc,
                 org, id_org,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_f, new.dt_f, 
                 'FECHAMENTO DE CAIXA: ' || _descr_cx || ' - ' || _descr_usr, 'C', new.vl_din_sld + new.vl_ch_sld, false, 
                 'MOV_CX.' || new.id_mov_cx, new.id_mov_cx,
                 new.id_usr_ult_alt, new.dt_hr_ult_alt,
                 new.id_op_fnc);
        end if;
        
        return new;
    else
    
        delete from tb_mov_fnc 
        where
            id_emp = old.id_emp and
            org = 'FEC.' || old.id_mov_cx;

        return old;
    end if;
    
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_bnc_bf (
)
RETURNS trigger AS
$body$
declare
    _ch record;
    _id_ch_sit integer;
    _ch_sit record;
begin
    if (tg_op = 'UPDATE' and old.conc <> new.conc and new.org = 'ch') then
        if (new.conc) then
        
            if (new.sit_conc = 'CONC') then
                perform fc_sit_ch(new.id_emp, new.id_org, 'Q', 'QUITADO', new.dt_conc, null);
            elsif (new.sit_conc = 'CHDEV') then
                select * into _ch
                from tb_ch
                where 
                    id_emp = new.id_emp and
                    id_ch = new.id_org;

                if (_ch.dt_dev1 is null) then
                
                    update tb_ch set
                        sit = 'D',
                        dt_dev1 = new.dt_conc,
                        id_mtv_dev_ch1 = new.id_mtv_dev_ch
                    where 
                        id_emp = new.id_emp and
                        id_ch = new.id_org;
                else
                    update tb_ch set
                        sit = 'D',
                        dt_dev2 = new.dt_conc,
                        id_mtv_dev_ch2 = new.id_mtv_dev_ch
                    where 
                        id_emp = new.id_emp and
                        id_ch = new.id_org;
                end if;
                
                perform fc_sit_ch(new.id_emp, new.id_org, 'D', 'DEVOLVIDO', new.dt_conc, null);
                
                
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, 
                     descr, conc, org, id_org, id_part, dt_conc, sit_conc, id_mtv_dev_ch,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_lanc, 
                     'CHEQUE DEVOLVIDO', new.conc, 'mov_bnc', new.id_mov_bnc, new.id_part, new.dt_conc, new.sit_conc, new.id_mtv_dev_ch,
                     new.id_op_fnc);
            end if;
            
        elsif (not new.conc) then
            select max(id_ch_sit) into _id_ch_sit
            from tb_ch_sit
            where
                id_emp = new.id_emp and
                id_ch = new.id_org and
                sit in ('Q', 'D');
                
            select * into _ch_sit
            from tb_ch_sit
            where
                id_emp = new.id_emp and
                id_ch = new.id_org and
                id_ch_sit < _id_ch_sit
            order by
                id_ch_sit desc
            limit 1;
            
            if found then
            
                update tb_ch set
                    dt_sit = _ch_sit.dt_sit,
                    sit = _ch_sit.sit
                where
                    id_emp = new.id_emp and
                    id_ch = new.id_org;
                
                delete from tb_ch_sit
                where
                    id_emp = new.id_emp and
                    id_ch = new.id_org and
                    id_ch_sit = _id_ch_sit;
                    
            end if;
            
            if (old.sit_conc = 'CHDEV' and old.org = 'ch') then
                delete from tb_mov_bnc
                where
                    id_emp = new.id_emp and
                    org = 'mov_bnc' and
                    id_org = new.id_mov_bnc;
            end if;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    elsif (tg_op = 'DELETE') then
        if (old.org = 'ch') then
            delete from tb_mov_bnc
            where
                id_emp = old.id_emp and
                org = 'mov_bnc' and
                id_org = old.id_mov_bnc;
        end if;
            
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_bnc_af (
)
RETURNS trigger AS
$body$
declare
    _id_op_fnc_str varchar;
    _id_op_fnc integer;
begin
    

    if ((tg_op = 'UPDATE') and (old.op = 'T')) or (tg_op = 'DELETE') then
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'MOV_BNC.' || old.id_mov_bnc;
                
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'MOV_BNC.' || old.id_mov_bnc;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        if (new.op = 'T') and (new.dst = 'C') and (coalesce(new.id_dst, 0) > 0) then
            
            _id_op_fnc := null;
            _id_op_fnc_str := fc_get_emp_cnf(new.id_emp, 15002);
            
            if (_id_op_fnc_str <> '') then
                _id_op_fnc := cast(_id_op_fnc_str as integer);
            end if;
            
            insert into tb_mov_fnc
                (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc, 
                 doc, descr, op, vl_lanc, 
                 org, id_org, id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_fnc'), new.id_dst, new.id_usr, new.dt_emis, substring(cast(current_time as varchar), 1, 8)::time,
                 new.nr_doc, new.descr, 'C', new.vl_lanc, 'MOV_BNC.' || new.id_mov_bnc, new.id_mov_bnc, _id_op_fnc);
        end if;
        
        if (new.op = 'T') and (new.dst = 'B') and (coalesce(new.id_dst, 0) > 0) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc,
                 nr_doc, descr, op, vl_lanc, conc,
                 org, id_org,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_dst, new.dt_emis, new.dt_venc, 
                 new.nr_doc, new.descr, 'C', new.vl_lanc, false, 'MOV_BNC.' || new.id_mov_bnc, new.id_mov_bnc,
                 new.id_op_fnc);
        end if;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
    
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    
    _op_fnc record;    
    
    _app_con varchar;
    _nr_doc integer;
    
    _vl_quit numeric;
    _vl_rest numeric;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        select sum(tb_bx_ct__ct.vl_quit), min(tb_bx_ct__ct.vl_rest) into _vl_quit, _vl_rest
        from tb_bx_ct__ct
        where
            tb_bx_ct__ct.id_emp_ct = new.id_emp and
            tb_bx_ct__ct.id_ct = new.id_ct;
    
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and (new.tp_doc = 'CH' or new.tp_doc = 'CH_PRZ')) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org, id_part,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, new.id_ct, new.id_part,
                 new.id_op_fnc);
        end if;
        
    elsif (tg_op = 'DELETE') then
        if (old.tp_ct = 'R') and (old.org = 'MOV_COLAB.ADTO') and (_app_con <> 'NEO_UNI') then
        
            delete from tb_recibo
            where
                id_emp = old.id_emp and
                org = 'MOV_COLAB.ADTO.' || old.id_ct;
                
        end if;
                

        if (old.tp_ct = 'P') and (_app_con <> 'NEO_UNI') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
                
            if (coalesce(old.org, '') like 'BX_MOV_FUNC.%') then
                _aux := regexp_split_to_array(old.org, '\.');
                
                update tb_mov_func set
                    id_bx_mov_func = null,
                    sit = 'P'
                where
                    id_emp = old.id_emp and
                    id_bx_mov_func = cast(_aux[2] as integer);
            end if;
                
        end if;
    end if;
    
    --
    -- Sef for boleto gera o numero do boleto
    --
    if ( (tg_op = 'INSERT' or (tg_op = 'UPDATE' and coalesce(new.nr_doc, '') = '') ) 
        and _app_con <> 'NEO_UNI') then
        
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'BLT') and (new.tp_ct = 'R') then
            _nr_doc := fc_num_blt(new.id_emp, new.id_op_fnc, new.id_cnt_bnc);
            
            new.nr_doc := cast(_nr_doc as varchar);
        end if;
    end if;
    
    if ((tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con = 'NEO_UNI')) then
        new.vl_quit := _vl_quit;
        new.vl_rest := _vl_rest;
        
        if (_vl_rest <= 0) then
            new.stat := 'Q';
        end if;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_contr_frete_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
    
    _id_ct integer;
    _num integer;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'INSERT') then
            new.num := fc_get_num_contr_frete(new.id_emp);
        end if;
        
        
        
        if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                org = 'CONTR_FRETE.' || old.id_contr_frete;
            
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            limit 1;
            
            _id_ct := nextval('sq_ct');
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                 dt_emis, dt_venc, vl_ct, stat, 
                 org, id_op_fnc, vl_quit, vl_rest, 
                 vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                 id_usr_ult_alt, dt_hr_ult_alt)
            values
                (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, new.id_part, new.num, 1, 1,
                 new.dt_emis, new.dt_emis, new.vl_tot, 'P', 
                 'CONTR_FRETE.' || new.id_contr_frete, _op_fnc.id_op_fnc, 0, new.vl_tot, 
                 new.vl_tot, 0, 0, 0, 0, 
                 new.id_usr_ult_alt, new.dt_hr_ult_alt);
                
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;    
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org, id_op_fnc, vl_quit, vl_rest,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_op_fnc, 0, new.vl_pagto,
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        select nome into _descr_part
        from tb_part
        where
            id_part = _bx_ct.id_part;
            
        if (_descr_part is null) then
            _descr_part := '';
        else
            _descr_part := ' ' || _descr_part;
        end if;
        
        if (new.obs is not null) then
            _descr_part := _descr_part || ' ' || new.obs;
        end if;
        
        _descr := ifthen(_bx_ct.tp_bx = 'R', 'REC ', 'PAG ');
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND',
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c,
                 new.id_op_fnc);
        
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN id_op_fnc INTEGER;

CREATE TABLE public.tb_veic_atr (
  id_veic INTEGER, 
  id_veic_atr INTEGER
) ;

ALTER TABLE public.tb_mov_cx
  ADD COLUMN id_op_fnc INTEGER;

CREATE TABLE public.tb_ct_pagto (
  id_emp INTEGER NOT NULL, 
  id_ct INTEGER NOT NULL, 
  id_ct_pagto INTEGER NOT NULL, 
  id_op_fnc INTEGER, 
  id_cnt_bnc INTEGER, 
  dt_pagto DATE, 
  vl_pagto NUMERIC(12,4), 
  nr_doc VARCHAR(20), 
  descr VARCHAR(150), 
  CONSTRAINT pk_ct_pagto PRIMARY KEY(id_emp, id_ct, id_ct_pagto)
) ;



ALTER TABLE public.tb_veic_atr
  ADD CONSTRAINT fk__veic_atr__veic FOREIGN KEY (id_veic)
    REFERENCES public.tb_veic(id_veic)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_veic_atr
  ADD CONSTRAINT fk__veic_atr__veic_atr FOREIGN KEY (id_veic_atr)
    REFERENCES public.tb_veic(id_veic)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_cx
  ADD CONSTRAINT fk__mov_cx__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_bnc
  ADD CONSTRAINT fk__mov_bnc__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ct_pagto
  ADD CONSTRAINT fk__ct_pagto__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ct_pagto
  ADD CONSTRAINT fk__ct_pagto__ct FOREIGN KEY (id_emp, id_ct)
    REFERENCES public.tb_ct(id_emp, id_ct)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ct_pagto
  ADD CONSTRAINT fk__ct_pagto__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

