SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
    
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    
    _op_fnc record;    
    
    _app_con varchar;
    _nr_doc integer;
    
    _vl_quit numeric;
    _vl_rest numeric;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        select sum(tb_bx_ct__ct.vl_quit), min(tb_bx_ct__ct.vl_rest) into _vl_quit, _vl_rest
        from tb_bx_ct__ct
        where
            tb_bx_ct__ct.id_emp_ct = new.id_emp and
            tb_bx_ct__ct.id_ct = new.id_ct;
    
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and (new.tp_doc = 'CH' or new.tp_doc = 'CH_PRZ')) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, new.id_ct, new.id_part);
        end if;
        
    elsif (tg_op = 'DELETE') then
        if (old.tp_ct = 'R') and (old.org = 'MOV_COLAB.ADTO') and (_app_con <> 'NEO_UNI') then
        
            delete from tb_recibo
            where
                id_emp = old.id_emp and
                org = 'MOV_COLAB.ADTO.' || old.id_ct;
                
        end if;
                

        if (old.tp_ct = 'P') and (_app_con <> 'NEO_UNI') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
                
            if (coalesce(old.org, '') like 'BX_MOV_FUNC.%') then
                _aux := regexp_split_to_array(old.org, '\.');
                
                update tb_mov_func set
                    id_bx_mov_func = null,
                    sit = 'P'
                where
                    id_emp = old.id_emp and
                    id_bx_mov_func = cast(_aux[2] as integer);
            end if;
                
        end if;
    end if;
    
    --
    -- Sef for boleto gera o numero do boleto
    --
    if ( (tg_op = 'INSERT' or (tg_op = 'UPDATE' and coalesce(new.nr_doc, '') = '') ) 
        and _app_con <> 'NEO_UNI') then
        
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'BLT') and (new.tp_ct = 'R') then
            _nr_doc := fc_num_blt(new.id_emp, new.id_op_fnc, new.id_cnt_bnc);
            
            new.nr_doc := cast(_nr_doc as varchar);
        end if;
    end if;
    
    if ((tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con = 'NEO_UNI')) then
        new.vl_quit := _vl_quit;
        new.vl_rest := _vl_rest;
        
        if (_vl_rest <= 0) then
            new.stat := 'Q';
        end if;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
    
        delete from tb_recibo
        where
            id_emp = old.id_emp and
            org like 'BX.' || old.id_bx_ct || '%';
            
        delete from tb_ct
        where
            id_emp = old.id_emp and
            (org = 'MOV_COLAB.CRED.ACT.' || old.id_bx_ct or
             org = 'MOV_COLAB.DEB.ACT.' || old.id_bx_ct);
            
    end if;
    
    
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        if (new.op = 'A') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            order by
                id_op_fnc
            limit 1;
        
            if (coalesce(new.vl_prox_deb, 0) > 0) then
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                     dt_emis, dt_venc, vl_ct, stat, 
                     org, id_op_fnc, vl_quit, vl_rest,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     obs)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, new.id_part, new.num_doc,
                     new.dt_bx, new.dt_bx, new.vl_prox_deb, 'P', 
                     'MOV_COLAB.DEB.ACT.' || new.id_bx_ct, _op_fnc.id_op_fnc, 0, new.vl_prox_deb,
                     new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     'ACERTO N ' || new.num_doc);
            end if;
            
            
            if (coalesce(new.vl_prox_cred, 0) > 0) then
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                     dt_emis, dt_venc, vl_ct, stat, 
                     org, id_op_fnc, vl_quit, vl_rest,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     obs)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, new.id_part, new.num_doc,
                     new.dt_bx, new.dt_bx, new.vl_prox_cred, 'P', 
                     'MOV_COLAB.CRED.ACT.' || new.id_bx_ct, _op_fnc.id_op_fnc, 0, new.vl_prox_cred,
                     new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     'ACERTO N ' || new.num_doc);
            end if;
        
        end if;
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

