SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_pdc_bf (
)
RETURNS trigger AS
$body$
declare
    _vl_cst_med_calc numeric;
    _vl_estq numeric;
    _vl_ult_cst_med numeric;
    _vl_cst_med numeric;
    _vl_cst_unt numeric;
begin
    if (tg_op = 'INSERT') then
    
        _vl_cst_unt := new.vl_prc_cst / new.vl_qtd;
    
        select 
            ((tb_item_estq.vl_estq * coalesce(tb_item_emp.vl_ult_cst_med, 0)) + (new.vl_qtd * _vl_cst_unt)) / (tb_item_estq.vl_estq + new.vl_qtd) as vl_cst_med_calc,
            tb_item_estq.vl_estq,
            coalesce(tb_item_emp.vl_ult_cst_med, 0) as vl_ult_cst_med
        into 
            _vl_cst_med_calc, 
            _vl_estq,
            _vl_ult_cst_med
        from tb_item_estq
        join tb_item_emp on
            (tb_item_estq.id_item = tb_item_emp.id_item and
             tb_item_estq.id_emp = tb_item_emp.id_emp)
        where
            tb_item_estq.id_item = new.id_item and
            tb_item_estq.id_emp = new.id_emp and
            tb_item_estq.id_dep = new.id_dep and
            tb_item_estq.id_grd_estq = new.id_grd_estq;
        
        if (_vl_estq > 0 and _vl_ult_cst_med > 0) then
            _vl_cst_med := _vl_cst_med_calc;
        else
            _vl_cst_med := _vl_cst_unt;
        end if;
            
        update tb_item_emp set
            vl_cst_rep = _vl_cst_unt,
            vl_cst_med = _vl_cst_med,
            vl_out = new.vl_out_imp / new.vl_qtd,
            vl_perc_desp_op = new.vl_perc_desp_op,
            vl_desp_op = new.vl_desp_op / new.vl_qtd,
            vl_perc_luc = new.vl_perc_luc,
            vl_luc = new.vl_luc / new.vl_qtd,
            vl_prc_vnd = new.vl_prc_vnd / new.vl_qtd,
            id_usr_ult_alt = new.id_usr_ult_alt,
            dt_hr_ult_alt = current_timestamp
        where
            id_emp = new.id_emp and
            id_item = new.id_item;
            
        perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'E', new.vl_qtd);
        
        return new;
        
    elsif (tg_op = 'DELETE') then
    
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'S', old.vl_qtd);
        
        return old;
        
    end if;
        
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_bf (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _nf_item_list refcursor;
    _nf_item record;
    _op_inv varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (tg_op in ('INSERT', 'UPDATE') ) and (_app_con <> 'NEO_UNI') then
        if (tg_op  = 'INSERT' and new.tp_emis = '[P]' and new.num is null) then
            new.num := fc_get_num_nf(new.id_emp, new.id_mod_nf, new.ser);
        end if;
    
    elsif (tg_op = 'DELETE') then
        
        update tb_ped set id_nf = null
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
    
        if (old.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
        
        open _nf_item_list for
            select *
            from tb_nf_item
            where
                id_emp = old.id_emp and
                id_nf = old.id_nf;
    
        fetch _nf_item_list into _nf_item;
        
        
    
        while found loop
            if (_nf_item.mov_estq) then
                perform fc_item_estq(_nf_item.id_item, _nf_item.id_emp, _nf_item.id_dep, _nf_item.id_grd_estq, _op_inv, _nf_item.vl_qtd_mov);
            end if;
            
            fetch _nf_item_list into _nf_item;
        end loop;
        
        close _nf_item_list;
        
        
        if (_app_con <> 'NEO_UNI') then
            delete from tb_mov_fnc
            where
                id_emp = old.id_emp and
                org like 'NF.' || old.id_nf || '%';
        end if;
 
    end if;
    
    
    if (tg_op in ('INSERT', 'UPDATE') ) then
        return new;
    else
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_calc_ir (
  _id_part integer,
  _dt date,
  _vl numeric
)
RETURNS numeric AS
$body$
declare
    _qtd_depend integer;
    _vl_bc_ir numeric;
    _vl_ir numeric;
    _part record;
    _vl_depend numeric;
    _vl_abat_ir numeric;
begin
    
    select count(*) into _qtd_depend
    from tb_part_cred
    where
        id_part = _id_part;
        
    select 
        distinct tb_ir.vl_depend 
    into _vl_depend
    from tb_ir
    where
        _dt between tb_ir.dt_i and tb_ir.dt_f;
        

    select
        tb_part.id_part,
        tb_part.vl_pa,
        tb_grp_disp.vl_perc_bc_ir
    into
        _part
    from tb_part
    join tb_grp_disp on
        (tb_part.id_grp_disp = tb_grp_disp.id_grp_disp)
    where 
        tb_part.id_part = _id_part;
        
        
    select
        sum(
            case 
                when tb_disp.tp = 'V' then tb_grp_disp_item.vl_disp
                when (_vl * tb_grp_disp_item.vl_disp / 100 > tb_disp.vl_max) then tb_disp.vl_max
                else _vl * tb_grp_disp_item.vl_disp / 100
            end 
        ) as vl_abat_ir
    into
        _vl_abat_ir
    from tb_part
    join tb_grp_disp on
        (tb_part.id_grp_disp = tb_grp_disp.id_grp_disp)
    join tb_grp_disp_item on
        (tb_part.id_grp_disp = tb_grp_disp_item.id_grp_disp)
    join tb_disp on
        (tb_grp_disp_item.id_disp = tb_disp.id_disp)
    where 
        tb_part.id_part = _id_part and
        tb_disp.abat_ir;
        
    
    raise notice '_part.vl_perc_bc_ir %', _part.vl_perc_bc_ir;
    
    _vl_bc_ir := cast(coalesce(_vl * _part.vl_perc_bc_ir / 100, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - coalesce(_part.vl_pa, 0);
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - cast(coalesce(_vl_depend * _qtd_depend, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - cast(coalesce(_vl_abat_ir, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;

    
    select
        (_vl_bc_ir * tb_ir.vl_aliq / 100) - tb_ir.vl_ded
    into
        _vl_ir
    from tb_ir
    where
        _dt between tb_ir.dt_i and tb_ir.dt_f and
        _vl_bc_ir between tb_ir.vl_i and tb_ir.vl_f;

    return _vl_ir;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_fml_item
  ALTER COLUMN vl_qtd TYPE NUMERIC(10,6);

ALTER TABLE public.tb_pdc_item
  ALTER COLUMN vl_qtd TYPE NUMERIC(10,6);

