CREATE SEQUENCE public.sq_cce_cte
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE TABLE public.tb_cce_cte (
  id_emp INTEGER NOT NULL, 
  id_cce_cte INTEGER NOT NULL, 
  ch_cte VARCHAR(44), 
  seq INTEGER, 
  dt_emis DATE, 
  hr_emis TIME WITHOUT TIME ZONE, 
  num_prot VARCHAR(60), 
  sit VARCHAR(1), 
  id_sit INTEGER, 
  descr_sit VARCHAR(255), 
  dt_hr_evt TIMESTAMP WITHOUT TIME ZONE, 
  xml TEXT, 
  CONSTRAINT pk_cce_cte PRIMARY KEY(id_emp, id_cce_cte)
) ;

CREATE TABLE public.tb_cce_cte_corr (
  id_emp INTEGER NOT NULL, 
  id_cce_cte INTEGER NOT NULL, 
  id_cce_cte_corr INTEGER NOT NULL, 
  grp VARCHAR(20), 
  cmp VARCHAR(20), 
  val VARCHAR(500), 
  num_item INTEGER, 
  CONSTRAINT pk_cce_cte_corr PRIMARY KEY(id_emp, id_cce_cte, id_cce_cte_corr)
) ;

ALTER TABLE public.tb_cce_cte_corr
  ADD CONSTRAINT fk__cce_cte_corr__cce_cte FOREIGN KEY (id_emp, id_cce_cte)
    REFERENCES public.tb_cce_cte(id_emp, id_cce_cte)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cce_cte
  ADD CONSTRAINT fk__cce_cte__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

