CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _id_cli_cons varchar;
    
    _list refcursor;
    _item record;
    
begin
    _app_con := fc_app_con();

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
    
        if (new.org = 'CONSIG') then
            update tb_consig set
                sit = 'F'
            where
                id_emp = new.id_emp and
                id_consig = new.id_org;
        end if;
        
        _id_cli_cons := fc_get_emp_cnf(new.id_emp, 01000);
        
        if (cast(new.id_cli as varchar) <> _id_cli_cons) then
            
            update tb_part set
                id_cond_pagto = new.id_cond_pagto,
                id_fm_pagto = new.id_fm_pagto
            where
                id_part = new.id_cli;
                
        end if;
        
        if (new.id_sit_vnd is not null and new.cd_ref is not null) then
            perform fc_vnd_ident_sit(new.id_emp, cast(new.cd_ref as integer), new.id_sit_vnd);
        end if;
        
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        if (old.org = 'CONSIG') then
            update tb_consig set
                sit = 'D'
            where
                id_emp = old.id_emp and
                id_consig = old.id_org;
        end if;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org like 'VND.' || old.id_vnd || '%';
    
    end if;
    
    
    --
    -- Venda cancelada ( mesmo se vier do neo UNI )
    --
    if (tg_op = 'UPDATE' and new.canc = true and new.canc <> old.canc) then
        --
        -- extorna o estoque
        --
        open _list for
            select *
            from tb_vnd_item
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd and
                mov_estq;

        fetch _list into _item;
                
            
        while found loop
                
            perform fc_item_estq(_item.id_item, _item.id_emp, _item.id_dep, _item.id_grd_estq, 'E', _item.vl_qtd_mov);
                
            fetch _list into _item;
                
        end loop;
            
        close _list;
            
        --
        -- extorna contas a receber
        --
        open _list for 
            select *
            from tb_vnd_parc
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                    
        fetch _list into _item;
            
        while found loop
                
            delete from tb_ct
            where 
                id_emp = new.id_emp and
                org = 'VND.' || new.id_vnd || '.' || _item.id_vnd_parc;
                
            delete from tb_mov_bnc
            where 
                id_emp = new.id_emp and
                org = 'VND.' || new.id_vnd || '.' || _item.id_vnd_parc;
                
            fetch _list into _item;
                
        end loop;
            
    end if;
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;