CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_pt_prc_bf (
)
RETURNS trigger AS
$body$
declare
    _nf_item record;
    _item_pt_prc record;
begin
    select * into _nf_item
    from tb_nf_item
    where
        id_emp = new.id_emp and
        id_nf = new.id_nf and
        id_nf_item = new.id_nf_item;
        
    if (_nf_item.at_prc_item) then
        select * into _item_pt_prc
        from tb_item_pt_prc
        where
            id_emp = new.id_emp and
            id_item = _nf_item.id_item and
            id_pt_prc = new.id_pt_prc;
            
        if (found) then
            update tb_item_pt_prc set
                vl_prc_vnd = new.vl_prc_vnd
            where
                id_emp = new.id_emp and 
                id_item = _nf_item.id_item and
                id_pt_prc = new.id_pt_prc;
        else
            insert into tb_item_pt_prc
                (id_emp, id_item, id_pt_prc, vl_prc_vnd)
            values
                (new.id_emp, _nf_item.id_item, new.id_pt_prc, new.vl_prc_vnd);
        end if;
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE TABLE public.tb_nf_item_pt_prc (
  id_emp INTEGER NOT NULL, 
  id_nf INTEGER NOT NULL, 
  id_nf_item INTEGER NOT NULL, 
  id_pt_prc INTEGER NOT NULL, 
  vl_prc_vnd NUMERIC(12,4), 
  CONSTRAINT pk_nf_item_pt_prc PRIMARY KEY(id_emp, id_nf, id_nf_item, id_pt_prc)
) ;

CREATE TRIGGER tr_nf_item_pt_prc_af
  AFTER INSERT OR UPDATE 
  ON public.tb_nf_item_pt_prc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_nf_item_pt_prc_bf();

ALTER TABLE public.tb_nf_item_pt_prc
  ADD CONSTRAINT fk__nf_item_pt_prc__nf_item FOREIGN KEY (id_emp, id_nf, id_nf_item)
    REFERENCES public.tb_nf_item(id_emp, id_nf, id_nf_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_nf_item_pt_prc
  ADD CONSTRAINT fk__nf_item_pt_prc__pt_prc FOREIGN KEY (id_pt_prc)
    REFERENCES public.tb_pt_prc(id_pt_prc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;