CREATE SEQUENCE public.sq_pt_prc
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE TABLE public.tb_pt_prc (
  id_pt_prc INTEGER NOT NULL, 
  descr VARCHAR(150), 
  CONSTRAINT pk_pt_prc PRIMARY KEY(id_pt_prc)
) ;

CREATE TABLE public.tb_item_pt_prc (
  id_item INTEGER NOT NULL, 
  id_emp INTEGER NOT NULL, 
  id_pt_prc INTEGER NOT NULL, 
  vl_prc_vnd NUMERIC(12,4), 
  CONSTRAINT pk_item_pt_prc PRIMARY KEY(id_item, id_emp, id_pt_prc)
) ;

ALTER TABLE public.tb_item_pt_prc
  ADD CONSTRAINT fk__item_pt_prc__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_pt_prc
  ADD CONSTRAINT fk__item_pt_prc__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_pt_prc
  ADD CONSTRAINT fk__item_pt_prc__pt_prc FOREIGN KEY (id_pt_prc)
    REFERENCES public.tb_pt_prc(id_pt_prc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;
