CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
    
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    
    _op_fnc record;    
    
    _app_con varchar;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and new.tp_doc = 'CH') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, new.id_ct, new.id_part);
        end if;
        
        --
        -- Gera proxima ct contrato
        --
        if (tg_op = 'UPDATE') then
        
            if (new.tp_ct = 'R' and new.stat = 'Q' and old.stat = 'P' and new.org like 'CONTR.%') then
                _aux := regexp_split_to_array(new.org, '\.');
                
                select count(*) into _qtd
                from tb_ct
                where
                    id_emp = new.id_emp and
                    id_part = new.id_part and
                    tp_ct = 'R' and
                    org = new.org and
                    dt_venc > new.dt_venc and
                    id_ct <> new.id_ct;
                
                if (_qtd = 0) then
                    
                    select * into _contr
                    from tb_part_contr
                    where
                        id_emp = new.id_emp and
                        id_part = new.id_part and
                        id_part_contr = cast(_aux[3] as integer);
                
                    if (found) then
                    
                        _dt_venc := fc_calc_venc(new.dt_venc, _contr.tp_interv, _contr.interv);
                        
                        if (_dt_venc <= _contr.dt_f) then
                            _id_cnt_bnc := null;
        
                            if (_contr.tp_doc = 'BLT') then
                                _id_cnt_bnc_str := fc_get_emp_cnf(new.id_emp, 01002);
                                
                                if (_id_cnt_bnc_str <> '') then
                                    _id_cnt_bnc := cast(_id_cnt_bnc_str as integer);
                                end if;
                            end if;
                            
                            select * into _op_fnc
                            from tb_op_fnc
                            where
                                tp_op_fnc = _contr.doc
                            order by
                                id_op_fnc
                            limit 1;
                        
                        
                            insert into tb_ct
                                (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, dt_emis, dt_venc,
                                 vl_ct, obs, stat, tp_doc, org, id_cnt_bnc, id_op_fnc, vl_quit, vl_rest)
                            values
                                (_contr.id_emp, nextval('sq_ct'), 'R', _contr.id_part, _contr.doc, new.parc + 1, new.parc + 1, new.dt_venc, _dt_venc,
                                 _contr.vl_contr, _contr.obs, 'P', _contr.tp_doc, new.org, _id_cnt_bnc, _op_fnc.id_op_fnc, 0, _contr.vl_contr);
                        end if;
                    end if;
                end if;
            elsif (new.tp_ct = 'R' and new.stat = 'P' and old.stat = 'Q' and new.org like 'CONTR.%') then
                _aux := regexp_split_to_array(new.org, '\.');
                    
                select * into _contr
                from tb_part_contr
                where
                    id_emp = new.id_emp and
                    id_part = new.id_part and
                    id_part_contr = cast(_aux[3] as integer);
                        
                if (found) then
                    _dt_venc := fc_calc_venc(new.dt_venc, _contr.tp_interv, _contr.interv);
                    
                    delete from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_part = new.id_part and
                        tp_ct = 'R' and
                        org = new.org and
                        dt_venc = _dt_venc and
                        stat = 'P' and
                        id_ct <> new.id_ct;
                end if;
            end if;
        end if;
        
        -- return new;
    elsif (tg_op = 'DELETE') then
        if (old.tp_ct = 'P') and (_app_con <> 'NEO_UNI') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    else
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;