CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct__ct_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        
        update tb_ct set
            stat = 'Q'
        where
            id_emp = new.id_emp_ct and
            id_ct = new.id_ct;
            
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        update tb_ct set
            stat = 'P'
        where
            id_emp = old.id_emp_ct and
            id_ct = old.id_ct;
            
    end if;
    
    return null;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_item_af (
)
RETURNS trigger AS
$body$
declare
    _grd_estq record;
    _grd_estq_list refcursor;
    _app_con varchar;
begin
    _app_con := fc_app_con();

    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
    
        open _grd_estq_list for
            select 
                tb_dep.id_emp,
                tb_dep.id_dep,
                tb_grd_estq.id_grd_estq
            from tb_dep, tb_grd_estq;
        
        fetch _grd_estq_list into _grd_estq;
        
        while found loop
            insert into tb_item_estq
                (id_item, id_emp, id_dep, id_grd_estq, vl_estq)
            values
                (new.id_item, _grd_estq.id_emp, _grd_estq.id_dep, _grd_estq.id_grd_estq, 0);
        
            fetch _grd_estq_list into _grd_estq;
        end loop;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;



CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;    
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto);
                     
        end if;
        
        select nome into _descr_part
        from tb_part
        where
            id_part = _bx_ct.id_part;
            
        if (_descr_part is null) then
            _descr_part := '';
        else
            _descr_part := ' ' || _descr_part;
        end if;
        
        _descr := ifthen(_bx_ct.tp_bx = 'R', 'RECEBIMENTO', 'PAGAMENTO');
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND');
        else
            perform fc_gera_mov_fnc(new.id_emp, _bx_ct.id_cx, _bx_ct.id_usr, _bx_ct.dt_bx, cast(current_time as time), trim(_descr || _descr_part),
                ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_bx_ct);
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;



CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
    _app_con varchar;
begin
    _app_con := fc_app_con();

    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
 
   end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, 
                     id_cnt_bnc, org,
                     obs)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, _nf.id_part_emt, new.nr_doc, new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     new.id_cnt_bnc, 'NF.' || new.id_nf || '.' || new.id_nf_parc,
                     'NF ' || _nf.num || ' ' || _op_fnc.descr);
                     
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC') then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _nf.dt_op, new.dt_venc, new.nr_doc, 'D', new.vl_parc, 'NF ' || _nf.num || ' ' || _op_fnc.descr, false,
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, _nf.id_nf,
                     _nf.id_part_emt, 'PEND');
            else
                perform fc_gera_mov_fnc(new.id_emp, _nf.id_cx, _nf.id_usr, _nf.dt_op, cast(current_time as time), 'NF ' || _nf.fant_emt || ' ' || _op_fnc.descr,
                    'D', new.vl_parc, 'NF.' || new.id_nf || '.' || new.id_nf_parc, new.id_nf);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;


CREATE OR REPLACE FUNCTION public.fc_tr_part_obs_bf (
)
RETURNS trigger AS
$body$
BEGIN
    if (fc_app_con() <> 'NEO_UNI') then
        new."dt_obs" = CURRENT_DATE;
    end if;

    return new;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;


CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
    _app_con varchar;
begin
    _app_con := fc_app_con();

    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        
        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc and
            id_org = old.id_vnd;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _vnd
        from tb_vnd
        where
            id_emp = new.id_emp and
            id_vnd = new.id_vnd;

        if (_vnd.tp_vnd = 'V') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
                _nr_doc := new.nr_doc;
                
                if (_op_fnc.tp_op_fnc = 'DUP') then
                    _nr_doc := new.id_vnd || '/' || new.nr_parc;
                end if;
            
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc);
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC') then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd,
                     _vnd.id_cli, 'PEND');
            else
                perform fc_gera_mov_fnc(new.id_emp, _vnd.id_cx, _vnd.id_usr, _vnd.dt_vnd, cast(current_time as time), 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr,
                    'C', new.vl_parc, 'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd);
            end if;
        end if;
        
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;