CREATE OR REPLACE FUNCTION public.fc_sit_ch (
  _id_emp integer,
  _id_ch integer,
  _sit varchar,
  _obs varchar
)
RETURNS boolean AS
$body$
declare
    _id_ch_sit integer;
begin
    select coalesce(max(id_ch_sit), 0) + 1 into _id_ch_sit
    from tb_ch_sit
    where
        id_emp = _id_emp and
        id_ch = _id_ch;
    
    insert into tb_ch_sit 
        (id_emp, id_ch, id_ch_sit, dt_sit, sit, obs)
    values
        (_id_emp, _id_ch, _id_ch_sit, current_date, _sit, _obs);
        
    update tb_ch set
        dt_sit = current_date,
        sit = _sit,
        obs = _obs
    where
        id_emp = _id_emp and
        id_ch = _id_ch;
        
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            id_nf = old.id_nf and
            id_nf_parc = old.id_nf_parc;

        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_nf = old.id_nf and
            id_nf_parc = old.id_nf_parc;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
                
                
            if (_op_fnc.tp_op_fnc = 'CRED') OR (_op_fnc.tp_op_fnc = 'BLT') then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, id_nf, id_nf_parc)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _nf.id_part_emt, cast(_nf.num as varchar), new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', new.id_nf, new.id_nf_parc);
                     
            elsif (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
                _id_ch := nextval('sq_ch');
                
                insert into tb_ch
                    (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                     dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_nf, id_nf_parc)
                values
                    (new.id_emp, _id_ch, 'P', _nf.id_part_emt, new.emit, new.cpf_cnpj,
                     _nf.dt_op, new.dt_venc, new.vl_parc, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_nf, new.id_nf_parc);
                
                perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'NOTA FISCAL ' || _nf.ser || ' - ' || _nf.num);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            id_vnd = old.id_vnd and
            id_vnd_parc = old.id_vnd_parc;

        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_vnd = old.id_vnd and
            id_vnd_parc = old.id_vnd_parc;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _vnd
        from tb_vnd
        where
            id_emp = new.id_emp and
            id_vnd = new.id_vnd;

        if (_vnd.tp_vnd = 'V') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
                
                
            if (_op_fnc.tp_op_fnc = 'CRED') then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, id_vnd, id_vnd_parc)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _vnd.id_cli, cast(new.id_vnd as varchar), new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', new.id_vnd, new.id_vnd_parc);
                     
            elsif (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
                _id_ch := nextval('sq_ch');
                
                insert into tb_ch
                    (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                     dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_vnd, id_vnd_parc)
                values
                    (new.id_emp, _id_ch, 'R', _vnd.id_cli, new.emit, new.cpf_cnpj,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_vnd, new.id_vnd_parc);
                
                perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'VENDA ' || new.id_vnd);
            end if;
            
        end if;
        
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_ch
  ADD COLUMN dt_sit DATE;

ALTER TABLE public.tb_ch
  ADD COLUMN id_bx_ct INTEGER;

ALTER TABLE public.tb_ch
  ADD COLUMN id_bx_ct_pagto INTEGER;

CREATE TABLE public.tb_ch_sit (
  id_emp INTEGER NOT NULL, 
  id_ch INTEGER NOT NULL, 
  id_ch_sit INTEGER NOT NULL, 
  dt_sit DATE, 
  sit VARCHAR(1), 
  obs VARCHAR(255)
) WITHOUT OIDS;

ALTER TABLE public.tb_ch_sit
  ADD CONSTRAINT pk_ch_sit 
    PRIMARY KEY (id_emp, id_ch, id_ch_sit);

ALTER TABLE public.tb_ch_sit
  ADD CONSTRAINT fk__ch_sit__ch FOREIGN KEY (id_emp, id_ch)
    REFERENCES public.tb_ch(id_emp, id_ch)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

