CREATE OR REPLACE FUNCTION public.fc_gera_mov_fnc (
  _id_emp integer,
  _id_cx integer,
  _id_usr integer,
  _dt_lanc date,
  _hr_lanc time,
  _descr varchar,
  _op varchar,
  _vl_lanc numeric,
  _org varchar,
  _id_org integer
)
RETURNS bigint AS
$body$
declare
    _mov_fnc record;
    _id_mov_fnc bigint;
begin
    select * into _mov_fnc
    from tb_mov_fnc
    where
        id_emp = _id_emp and
        op = _op and
        org = _org and
        id_org = _id_org;
    
    if found then
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            id_mov_fnc = _mov_fnc.id_mov_fnc;
    end if;
    
    _id_mov_fnc := nextval('sq_mov_fnc');
        
    insert into tb_mov_fnc 
        (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc,
         descr, op, vl_lanc, org, id_org)
    values
        (_id_emp, _id_mov_fnc, _id_cx, _id_usr, _dt_lanc, _hr_lanc, 
         _descr, _op, _vl_lanc, _org, _id_org);
    
    return _id_mov_fnc;    
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op varchar;
    _descr varchar;
BEGIN
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        select nome into _descr
        from tb_part
        where
            id_part = new.id_part;
                
        if (new.tp_bx = 'R') then
            _op := 'C';
            _descr := 'RECEBIMENTO ' || _descr;
        else
            _op := 'D';
            _descr := 'PAGAMENTO ' || _descr;
        end if;
            
        perform fc_gera_mov_fnc(new.id_emp, new.id_cx, new.id_usr, new.dt_bx, cast(current_time as time), _descr,
                _op, new.vl_pag, 'BX_CT', new.id_bx_ct);
        
    elsif (tg_op = 'DELETE') then
        
        select nome into _descr
        from tb_part
        where
            id_part = old.id_part;
                
        if (old.tp_bx = 'R') then
            _op := 'D';
            _descr := 'RECEBIMENTO CANCELADO ' || _descr;
        else
            _op := 'C';
            _descr := 'PAGAMENTO CANCELADO ' || _descr;
        end if;
            
        perform fc_gera_mov_fnc(old.id_emp, old.id_cx, old.id_usr, old.dt_bx, cast(current_time as time), _descr,
                _op, old.vl_pag, 'BX_CT', old.id_bx_ct);
    end if;
    
    return null;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

ALTER TABLE public.tb_bx_ct
  ADD COLUMN id_cx INTEGER;

ALTER TABLE public.tb_bx_ct
  ADD COLUMN id_usr INTEGER;

ALTER TABLE public.tb_rel
  ADD COLUMN sql TEXT;

ALTER TABLE public.tb_rel_cab
  ADD COLUMN tp_fil VARCHAR(1);

ALTER TABLE public.tb_rel_cab
  ADD COLUMN arg_fil VARCHAR(255);

ALTER TABLE public.tb_rel_item
  ADD COLUMN sql TEXT;

ALTER TABLE public.tb_bx_ct
  ADD CONSTRAINT fk__bx_ct__usr FOREIGN KEY (id_usr)
    REFERENCES public.tb_usr(id_usr)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_bx_ct
  ADD CONSTRAINT fk__bx_ct__cx FOREIGN KEY (id_emp, id_cx)
    REFERENCES public.tb_cx(id_emp, id_cx)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_bx_ct_af
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_bx_ct FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_bx_ct_af();

