CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _nf record;
    _op varchar;
    _op_inv varchar;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;
        
        if (_nf.tp_op = '[E]') then
            _op := 'E';
            _op_inv := 'S';
        else
            _op := 'S';
            _op_inv := 'E';
        end if;
        
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq) then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
        end if;
        
        update tb_item_emp set
            vl_cst_rep = new.vl_cst_rep,
            vl_cst_med = new.vl_cst_med,
            dt_ult_cmp = _nf.dt_op
        where
            id_emp = new.id_emp and
            id_item = new.id_item;
            
                
        if (new.at_prc_item) then
        
            update tb_item_emp set
                vl_out = new.vl_out_prc,
                vl_perc_desp_op = new.vl_perc_desp_op_prc,
                vl_desp_op = new.vl_desp_op_prc,
                vl_perc_luc = new.vl_perc_luc_prc,
                vl_luc = new.vl_luc_prc,
                vl_prc_vnd = new.vl_prc_vnd
            where
                id_emp = new.id_emp and
                id_item = new.id_item;
                
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
            
        if (_nf.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
    
        if (found and old.mov_estq) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_nf_item
  RENAME COLUMN vl_vnd_prc TO vl_prc_vnd;

