CREATE OR REPLACE FUNCTION public.fc_gera_nfe_inut (
  _id_emp integer,
  _dt_emis date,
  _id_usr integer
)
RETURNS integer AS
$body$
declare
    _list refcursor;
    _item record;
    _qtd integer;
    _last_num integer;
    
    _ano integer;
    _id_mod_nf varchar;
    _ser varchar;
    _num_ini integer;
    _num_fin integer;
    _qtd_inut integer;
    _qtd_proc integer;
begin

    open _list for
        select
            tb_nf.id_emp,
            tb_nf.id_mod_nf,
            tb_nf.ser,
            tb_nf.num,
            tb_nf.dt_emis
        from tb_nf
        where
            tb_nf.id_emp = _id_emp and
            tb_nf.tp_emis = '[P]' and
            tb_nf.id_mod_nf in ('55', '65') and
            tb_nf.dt_emis >= _dt_emis
        order by
            id_emp,
            id_mod_nf,
            ser,
            num;

    fetch _list into _item;
    
    _num_ini   := 0;
    _num_fin   := 0;
    
    _qtd       := 0;
    _last_num  := 0;
    
    _id_mod_nf := '';
    _ser       := '';
    
    _qtd_proc  := 0;
    
    while (found) loop
        if (_id_mod_nf <> _item.id_mod_nf or _ser <> _item.ser) then
            
            _last_num  := _item.num;
            _id_mod_nf := _item.id_mod_nf;
            _ser       := _item.ser;
            
        else
        
            if (_last_num + 1 < _item.num) then
        
                _num_ini := _last_num + 1;
                _num_fin := _item.num - 1;
        
                select count(*) into _qtd_inut
                from tb_nfe_inut
                where
                    tb_nfe_inut.id_emp = _id_emp and
                    tb_nfe_inut.id_mod_nf = _id_mod_nf and
                    tb_nfe_inut.ser = _ser and
                    _num_ini between tb_nfe_inut.num_ini and tb_nfe_inut.num_fin;
                    
                if (_qtd_inut = 0) then
                
                    insert into tb_nfe_inut
                        (id_emp, id_nfe_inut, ano, id_mod_nf, ser, num_ini, num_fin, just, dt_hr_cad, id_usr_cad)
                    values
                        (_id_emp, nextval('sq_nfe_inut'), _ano, _id_mod_nf, _ser, _num_ini, _num_fin, 'PERDA DE SEQUENCIA DO SISTEMA', current_timestamp, _id_usr);
    
                    _qtd_proc := _qtd_proc + 1;
                    
                    -- raise notice 'Inut: % ', _qtd_inut;
                
                    -- raise notice 'Ano: %  Modelo: %  Serie: %  Inicio: %  Final: %', _ano, _item.id_mod_nf, _item.ser, _last_num +1, _item.num -1;
                end if;
                
            end if;
            
        end if;
        
        _qtd      := _qtd + 1;
        _last_num := _item.num;
        _ano      := extract(year from _item.dt_emis);
        
        fetch _list into _item;
    end loop;    
    
    -- raise notice 'QTD: %', _qtd;

    return _qtd_proc;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

