DROP TRIGGER tr_pix_bf ON public.tb_pix;

CREATE OR REPLACE FUNCTION public.fc_tr_pix_bf (
)
RETURNS trigger AS
$body$
declare
    _mov_bnc record;
begin
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        if (new.sit = 'CONC') then
            
            select * into _mov_bnc
            from tb_mov_bnc
            where
                id_emp = new.id_emp and
                tp_org = 'PIX' and
                id_org = new.id_pix;
                
            if not found then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, tp_org, id_org, 
                     id_part, sit_conc,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
                     id_plano_ct, id_cnt_cst,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_hr_pag, new.dt_hr_pag, new.id_pix, 'C', new.vl_lanc, new.descr || coalesce(' - ' || new.nome_pag, ''), false,
                     'PIX.' || new.id_pix, 'PIX', new.id_pix,
                     new.id_part, 'PEND',
                     new.id_usr_ult_alt, new.dt_hr_ult_alt, new.id_usr_ult_alt, new.dt_hr_ult_alt, new.comp_cad, new.comp_ult_alt,
                     new.id_plano_ct, new.id_cnt_cst,
                     new.id_op_fnc);
            end if;    
        end if;
    
    
        return new;
    else 
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TRIGGER tr_pix_bf
  BEFORE INSERT OR UPDATE 
  ON public.tb_pix FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_pix_bf();

