CREATE OR REPLACE FUNCTION public.fc_fec_invt (
  _id_emp integer,
  _id_invt integer []
)
RETURNS boolean AS
$body$
declare
    _item record;
    _list refcursor;
    
    _id_mnt_estq integer;
    _id_mnt_estq_item integer;
    _id_dep integer;
    _op varchar;
begin
    open _list for
        select
            tb.id_emp,
            tb.id_dep,
            cast(
                case 
                    when (tb.vl_qtd - coalesce(tb_item_estq.vl_estq, 0) > 0) then 'E'
                    when (tb.vl_qtd - coalesce(tb_item_estq.vl_estq, 0) < 0) then 'S'
                end as varchar
            ) as op,
            tb.id_item,
            tb.id_grd_estq,
            tb.id_und_med_mov,
            tb.vl_qtd - coalesce(tb_item_estq.vl_estq, 0) as vl_qtd,
            tb.vl_tot,
            tb.vl_prc_cst,
            tb.id_usr_cad, 
            tb.dt_hr_cad, 
            tb.id_usr_ult_alt, 
            tb.dt_hr_ult_alt
            
        from 
        (

            select
                tb_invt.id_usr_cad, 
                tb_invt.dt_hr_cad, 
                tb_invt.id_usr_ult_alt, 
                tb_invt.dt_hr_ult_alt,
                tb_invt.id_emp,
                tb_invt.id_dep,
                tb_invt_item.id_item,
                tb_invt_item.id_grd_estq,
                tb_invt_item.id_und_med_mov,
                sum(tb_invt_item.vl_qtd_mov) as vl_qtd,
                sum(tb_invt_item.vl_tot) as vl_tot,
                avg(tb_invt_item.vl_prc_cst) as vl_prc_cst
            from tb_invt
            join tb_invt_item on
                (tb_invt.id_emp = tb_invt_item.id_emp and
                 tb_invt.id_invt = tb_invt_item.id_invt)
            where
                tb_invt.id_emp = _id_emp and
                _id_invt && array[tb_invt.id_invt] and
                tb_invt.sit = 'A'
            group by
                tb_invt.id_usr_cad, 
                tb_invt.dt_hr_cad, 
                tb_invt.id_usr_ult_alt, 
                tb_invt.dt_hr_ult_alt,
                tb_invt.id_emp,
                tb_invt.id_dep,
                tb_invt_item.id_item,
                tb_invt_item.id_grd_estq,
                tb_invt_item.id_und_med_mov

        ) as tb
        left outer join tb_item_estq on
            (tb.id_emp = tb_item_estq.id_emp and
             tb.id_dep = tb_item_estq.id_dep and
             tb.id_item = tb_item_estq.id_item and
             tb.id_grd_estq = tb_item_estq.id_grd_estq)
        order by
            id_emp,
            id_dep,
            op,
            id_item,
            id_grd_estq,
            id_und_med_mov,
            vl_qtd;

    fetch _list into _item;
    
    _op := '';
    _id_dep := 0;
    
    while (found) loop
    
        if (_op <> _item.op and _id_dep <> _item.id_dep) then
            _id_mnt_estq := nextval('sq_mnt_estq');
            
            insert into tb_mnt_estq
                (id_emp, id_mnt_estq, dt_mnt_estq, op, id_dep_dst, descr, 
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt)
            values
                (_id_emp, _id_mnt_estq, current_date, _item.op, _item.id_dep, 'INVENTARIO',
                 _item.id_usr_cad, _item.dt_hr_cad, _item.id_usr_ult_alt, _item.dt_hr_ult_alt);
                
            _op := _item.op;
            _id_dep := _item.id_dep;
            _id_mnt_estq_item := 1;
        end if;
        
        insert into tb_mnt_estq_item
            (id_emp, id_mnt_estq, id_mnt_estq_item, op, id_dep_dst,
             id_item, id_grd_estq, id_und_med, vl_qtd, id_und_med_mov, vl_qtd_mov, 
             vl_unt, vl_tot,
             id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt)
        values
            (_id_emp, _id_mnt_estq, _id_mnt_estq_item, _op, _id_dep,
             _item.id_item, _item.id_grd_estq, _item.id_und_med_mov, abs(_item.vl_qtd), _item.id_und_med_mov, abs(_item.vl_qtd),
             _item.vl_prc_cst, _item.vl_tot,
             _item.id_usr_cad, _item.dt_hr_cad, _item.id_usr_ult_alt, _item.dt_hr_ult_alt);
        
        _id_mnt_estq_item := _id_mnt_estq_item + 1;
        
        fetch _list into _item;
    
    end loop;
    
    update tb_invt set
        sit = 'F'
    where
        id_emp = _id_emp and
        _id_invt && array[tb_invt.id_invt] and
        sit = 'A';


    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

