SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_rom_frete_parc_cli_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _rom_frete record;
    _id_veic integer;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'ROM_FRETE.CLI' and
            id_org = old.id_rom_frete and
            id_org_item = old.id_rom_frete_parc_cli;
            -- org = 'ROM_FRETE.CLI.' || old.id_rom_frete || '.' || old.id_rom_frete_parc_cli;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
    
        select * into _rom_frete
        from tb_rom_frete
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete;
    
        _id_ct := nextval('sq_ct');
        
        select id_veic into _id_veic
        from tb_rom_frete_item
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete
        order by
            id_rom_frete_item
        limit 1;
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             id_plano_ct, id_cnt_bnc,
             id_rom_frete, id_veic,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _rom_frete.id_tom, new.id_rom_frete, new.id_rom_frete_parc_cli, new.qtd_parc,
             _rom_frete.dt_lanc, new.dt_venc, new.vl_parc, 'P', 
             'ROM_FRETE.CLI.' || new.id_rom_frete || '.' || new.id_rom_frete_parc_cli, 'ROM_FRETE.CLI', new.id_rom_frete, new.id_rom_frete_parc_cli, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             new.id_plano_ct, new.id_cnt_bnc,
             new.id_rom_frete, _id_veic,
             new.vl_parc, 0, 0, 0, 0, 
             _rom_frete.id_usr_ult_alt, _rom_frete.dt_hr_ult_alt);
        
        if (_op_fnc.auto_bx) then
            perform fc_bx_ct(new.id_emp, _id_ct);
        end if;
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_rom_frete_item_parc_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _rom_frete_item record;
    _rom_frete record;
    _descr varchar;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'ROM_FRETE.ITEM' and
            id_org = old.id_rom_frete and
            id_org_item = old.id_rom_frete_item and
            org = 'ROM_FRETE.ITEM.' || old.id_rom_frete || '.' || old.id_rom_frete_item || '.' || old.id_rom_frete_item_parc;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            /*tp_op_fnc = 'DUP'
        limit 1;*/
    
        select
            tb_rom_frete.*,
            trim(substring(tb_part_tom.nome, 1, 15)) as nome_tom,
            trim(substring(tb_part_dest.nome, 1, 15)) as nome_dest
        into _rom_frete
        from tb_rom_frete
        left outer join tb_part as tb_part_tom on
            (tb_rom_frete.id_tom = tb_part_tom.id_part)
        left outer join tb_part as tb_part_dest on
            (tb_rom_frete.id_dest = tb_part_dest.id_part)
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete;
            
        select * into _rom_frete_item
        from tb_rom_frete_item
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete and
            id_rom_frete_item = new.id_rom_frete_item;
    
        _id_ct := nextval('sq_ct');
        
        _descr := _rom_frete.nome_tom || ' / ' || _rom_frete.nome_dest || ' R. ' || _rom_frete.id_rom_frete;-- || ' D. ' || _rom_frete.vl_qtd;
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             obs,
             id_plano_ct, id_cnt_cst, id_cnt_bnc,
             id_rom_frete, id_veic,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _rom_frete_item.id_colab, new.id_rom_frete, new.parc, new.qtd_parc,
             _rom_frete.dt_lanc, new.dt_venc, new.vl_parc, 'P', 
             'ROM_FRETE.ITEM.' || new.id_rom_frete || '.' || new.id_rom_frete_item || '.' || new.id_rom_frete_item_parc, 'ROM_FRETE.ITEM', new.id_rom_frete, new.id_rom_frete_item, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             _descr,
             new.id_plano_ct, new.id_cnt_cst, new.id_cnt_bnc,
             new.id_rom_frete, _rom_frete_item.id_veic,
             new.vl_parc, 0, 0, 0, 0, 
             _rom_frete.id_usr_ult_alt, _rom_frete.dt_hr_ult_alt);
       
         if (_op_fnc.auto_bx) then
            perform fc_bx_ct(new.id_emp, _id_ct);
        end if;
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
    
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    
    _op_fnc record;    
    
    _app_con varchar;
    _nr_doc integer;
    
    _vl_quit numeric;
    _vl_rest numeric;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and (new.tp_doc = 'CH' or new.tp_doc = 'CH_PRZ')) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, tp_org, id_org, 
                 id_part,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, 'CT', new.id_ct, 
                 new.id_part,
                 new.id_op_fnc);
        end if;

        
    elsif (tg_op = 'DELETE') then
        if (old.fat) then
            update tb_ct set
                stat = 'P',
                id_fat = null
            where
                id_fat = old.id_ct;
        end if;
        
        if (coalesce(old.id_fat, 0) > 0) then
            raise exception 'Esta conta esta vinculada a uma fatura e nao pode ser excluida';
            return null;
        end if;
        
        
        if (old.tp_ct = 'R') and (old.org = 'MOV_COLAB.ADTO') and (_app_con <> 'NEO_UNI') then
        
            delete from tb_recibo
            where
                id_emp = old.id_emp and
                org = 'MOV_COLAB.ADTO.' || old.id_ct;
                
        end if;
                

        if (old.tp_ct = 'P') and (_app_con <> 'NEO_UNI') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
                
            if (coalesce(old.org, '') like 'BX_MOV_FUNC.%') then
                _aux := regexp_split_to_array(old.org, '\.');
                
                update tb_mov_func set
                    id_bx_mov_func = null,
                    sit = 'P'
                where
                    id_emp = old.id_emp and
                    id_bx_mov_func = cast(_aux[2] as integer);
            end if;
                
        end if;
    end if;
    
    --
    -- Exclui a baixa automatica
    --
    if (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        delete from tb_bx_ct 
        where
            id_emp = old.id_emp and
            org = 'CT.' || old.id_ct;
    end if;
    
    --
    -- Sef for boleto gera o numero do boleto
    --
    if ( (tg_op = 'INSERT' or (tg_op = 'UPDATE' and coalesce(new.nr_doc, '') = '') ) 
        and _app_con <> 'NEO_UNI') then
        
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'BLT') and (new.tp_ct = 'R') then
            _nr_doc := fc_num_blt(new.id_emp, new.id_op_fnc, new.id_cnt_bnc);
            
            new.nr_doc := cast(_nr_doc as varchar);
        end if;
    end if;
    
    if ((tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con = 'NEO_UNI')) then
        
        select sum(tb_bx_ct__ct.vl_quit), min(tb_bx_ct__ct.vl_rest) into _vl_quit, _vl_rest
        from tb_bx_ct__ct
        where
            tb_bx_ct__ct.id_emp_ct = new.id_emp and
            tb_bx_ct__ct.id_ct = new.id_ct;
    

        new.vl_quit := coalesce(_vl_quit, 0);
        new.vl_rest := coalesce(_vl_rest, new.vl_ct);
        
        if (_vl_rest <= 0) then
            new.stat := 'Q';
        end if;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_bx_ct (
  _id_emp integer,
  _id_ct integer
)
RETURNS boolean AS
$body$
declare
    _ct record;
    _op_fnc record;
    _id_bx_ct integer;
begin
    select * into _ct
    from tb_ct
    where
        id_emp = _id_emp and
        id_ct = _id_ct;
    
    --
    -- Exclui a baixa automatica
    --
    delete from tb_bx_ct 
    where
        id_emp = _ct.id_emp and
        org = 'CT.' || _ct.id_ct;
        

    select * into _op_fnc
    from tb_op_fnc
    where
        id_op_fnc = _ct.id_op_fnc;
    
    
    _id_bx_ct := nextval('sq_bx_ct');

    
    insert into tb_bx_ct
        (id_emp, id_bx_ct, dt_bx, id_part,
         vl_sub_tot, vl_tot, vl_pag, vl_inf, vl_desc_perc, vl_desc, vl_acr_perc, vl_acr, vl_rest, vl_troco,
         id_plano_ct,
         obs, tp_bx, id_cx, op, canc,
         id_usr, id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, id_est_ult_alt, id_est_cad,
         org, id_veic)
    values
        (_ct.id_emp, _id_bx_ct, _ct.dt_emis, _ct.id_part,
         _ct.vl_ct, _ct.vl_ct, _ct.vl_ct, _ct.vl_ct, 0, 0, 0, 0, 0, 0,
         _ct.id_plano_ct,
         _ct.obs, _ct.tp_ct, _ct.id_cx, 'B', false,
         _ct.id_usr_cad, _ct.id_usr_cad, _ct.dt_hr_cad, _ct.id_usr_ult_alt, _ct.dt_hr_ult_alt, _ct.id_est_ult_alt, _ct.id_est_cad,
         'CT.' || _ct.id_ct, _ct.id_veic);
             
    insert into tb_bx_ct__ct
        (id_emp, id_bx_ct, id_emp_ct, id_ct,
         vl_sub_tot, vl_desc_perc, vl_desc, vl_acr_perc, vl_acr, vl_tot, vl_quit, vl_rest,
         id_plano_ct,
         dt_hr_ult_alt, id_usr_ult_alt, id_usr_cad, dt_hr_cad, id_est_ult_alt, id_est_cad)
    values
        (_ct.id_emp, _id_bx_ct, _ct.id_emp, _ct.id_ct,
         _ct.vl_ct, 0, 0, 0, 0, _ct.vl_ct, _ct.vl_ct, 0,
         _ct.id_plano_ct,
         _ct.dt_hr_ult_alt, _ct.id_usr_ult_alt, _ct.id_usr_cad, _ct.dt_hr_cad, _ct.id_est_ult_alt, _ct.id_est_cad);
         
    insert into tb_bx_ct_pagto
        (id_emp, id_bx_ct, id_bx_ct_pagto, 
         id_op_fnc, dt_venc, vl_pagto, vl_inf,
         id_cnt_bnc,
         id_plano_ct,
         id_cnt_cst,
         obs,
         dt_hr_ult_alt, id_usr_ult_alt, id_usr_cad, dt_hr_cad, id_est_ult_alt, id_est_cad, comp_cad, comp_ult_alt)
    values
        (_ct.id_emp, _id_bx_ct, 1,
         _ct.id_op_fnc, _ct.dt_venc, _ct.vl_ct, _ct.vl_ct,
         _ct.id_cnt_bnc,
         _ct.id_plano_ct,
         _ct.id_cnt_cst,
         _ct.obs,
         _ct.dt_hr_ult_alt, _ct.id_usr_ult_alt, _ct.id_usr_cad, _ct.dt_hr_cad, _ct.id_est_ult_alt, _ct.id_est_cad, _ct.comp_cad, _ct.comp_ult_alt);
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_rom_frete_parc_cli
  ADD COLUMN id_cnt_bnc INTEGER;

ALTER TABLE public.tb_rom_frete_item_parc
  ADD COLUMN id_op_fnc INTEGER;

ALTER TABLE public.tb_rom_frete_item_parc
  ADD COLUMN id_plano_ct VARCHAR(100);

ALTER TABLE public.tb_rom_frete_item_parc
  ADD COLUMN id_cnt_cst INTEGER;

ALTER TABLE public.tb_rom_frete_item_parc
  ADD COLUMN obs VARCHAR(255);

ALTER TABLE public.tb_rom_frete_item_parc
  ADD COLUMN id_cnt_bnc INTEGER;

ALTER TABLE public.tb_ct
  ADD COLUMN id_cx INTEGER;

ALTER TABLE public.tb_rom_frete_parc_cli
  ADD CONSTRAINT fk__rom_frete_parc_cli__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_item_parc
  ADD CONSTRAINT fk__rom_frete_item_parc__plano_ct FOREIGN KEY (id_plano_ct)
    REFERENCES public.tb_plano_ct(id_plano_ct)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_item_parc
  ADD CONSTRAINT fk__rom_frete_item_parc__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_item_parc
  ADD CONSTRAINT fk__rom_frete_item_parc__cnt_cst FOREIGN KEY (id_cnt_cst)
    REFERENCES public.tb_cnt_cst(id_cnt_cst)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_item_parc
  ADD CONSTRAINT fk__rom_frete_item_parc__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

