CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _nf record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;
        
        if (_nf.tp_op = '[E]') then
            _op := 'E';
            _op_inv := 'S';
        else
            _op := 'S';
            _op_inv := 'E';
        end if;
        
        if (tg_op = 'UPDATE') then
        	-- se estava para movimentar o estoque, volta o estoque
            if 
            	(old.mov_estq and (new.mov_estq <> old.mov_estq)) or
                (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) or
                (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.id_item <> old.id_item) or
                (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.id_dep <> old.id_dep) or
                (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.id_grd_estq <> old.id_grd_estq)
            then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
            end if;
            
            -- se o novo esta para movimentar o estoque, insere o estoque
            if 
            	(new.mov_estq and (new.mov_estq <> old.mov_estq)) or
                (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) or
                (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and new.id_item <> old.id_item) or
                (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and new.id_dep <> old.id_dep) or
                (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and new.id_grd_estq <> old.id_grd_estq)
            then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
            end if;
            
--            if (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) then
--                
--            end if;
        end if;
        
        if (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
            
        if (_nf.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
    
        if (found and old.mov_estq and coalesce(old.mov_grd_estq, false) = false) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;