SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _ct record;
    _op varchar;
    _descr varchar;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') then
        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'CT_PAGTO.' || old.id_ct || '.' || old.id_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        select * into _ct
        from tb_ct
        where
            id_emp = new.id_emp and
            id_ct = new.id_ct;
        
        if (_ct.tp_ct = 'R') then
            _op := 'D';
        else
            _op := 'C';
        end if;
        
        
        _descr := '';
        
        if (_ct.org like 'MOV_COLAB.ADTO%') then
            _descr := 'ADTO ' || _ct.id_ct;
        end if;
        
        if (new.descr is not null) then
            _descr := _descr || ' - ' || new.descr;
        end if;
        
        
        
        insert into tb_mov_bnc
            (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
             org, id_org,
             id_part, sit_conc,
             id_usr_ult_alt, dt_hr_ult_alt,
             id_ct_ctb_d, id_ct_ctb_c,
             id_plano_ct, id_cnt_cst,
             id_op_fnc)
        values
            (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_pagto, new.dt_pagto, new.nr_doc, _op, new.vl_pagto, _descr, false,
             'CT_PAGTO.' || new.id_ct || '.' || new.id_ct_pagto, new.id_ct,
             _ct.id_part, 'PEND',
             new.id_usr_ult_alt, new.dt_hr_ult_alt,
             _ct.id_ct_ctb_d, _ct.id_ct_ctb_c,
             _ct.id_plano_ct, _ct.id_cnt_cst,
             new.id_op_fnc);
    end if;
                     
                     
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    else
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_op_fnc
  ADD COLUMN auto_bx BOOLEAN;

ALTER TABLE public.tb_part_cota
  ADD COLUMN id_plano_ct VARCHAR(100);

ALTER TABLE public.tb_part_cota
  ADD COLUMN id_cnt_cst INTEGER;

ALTER TABLE public.tb_part_cota
  ADD COLUMN obs VARCHAR(150);

ALTER TABLE public.tb_part
  ADD COLUMN id_plano_ct_cota VARCHAR(100);

ALTER TABLE public.tb_part
  ADD COLUMN id_cnt_cst_cota INTEGER;

ALTER TABLE public.tb_part
  ADD COLUMN obs_cota VARCHAR(150);

ALTER TABLE public.tb_part_cota
  ADD CONSTRAINT fk__part_cota__plano_ct FOREIGN KEY (id_plano_ct)
    REFERENCES public.tb_plano_ct(id_plano_ct)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_cota
  ADD CONSTRAINT fk__part_cota__cnt_cst FOREIGN KEY (id_cnt_cst)
    REFERENCES public.tb_cnt_cst(id_cnt_cst)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

