SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_item_bf (
)
RETURNS trigger AS
$body$
declare 
    _item_emp record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
            end if;
            
            if (new.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov or old.mov_estq <> new.mov_estq) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
        end if;
        
        select * into _item_emp
        from tb_item_emp
        where
            id_item = new.id_item and
            id_emp = new.id_emp;
                
        new.vl_cst_rep = _item_emp.vl_cst_rep;
        new.vl_cst_med = _item_emp.vl_cst_med;
        
        
        
        
        return new;
    
    elsif (tg_op = 'DELETE') then
        
        if (old.mov_estq) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_item_emp_bf (
)
RETURNS trigger AS
$body$
declare
    _id_emp_matriz integer;
    _cnf_item_alt_prc_filial varchar;
    
    _filial record;
    _app_con varchar;
    
    _cmp_prc_unt_item_agr varchar;
begin
    _app_con := fc_app_con();
    
    if (_app_con = 'NEO_UNI') then
        return new;
    end if;

    if (tg_op = 'INSERT') 
        or (tg_op = 'UPDATE'
            and (old.vl_cst_med <> new.vl_cst_med
                 or old.vl_cst_rep <> new.vl_cst_rep
                 or old.vl_prc_vnd <> new.vl_prc_vnd)) then
        --
        -- Altera/Insere os preços nas filiais
        --
        _cnf_item_alt_prc_filial := fc_get_emp_cnf(new.id_emp, 07011);
        
        if (lower(_cnf_item_alt_prc_filial) = 'true') then
            _id_emp_matriz := fc_id_emp_matriz();
            if (new.id_emp = _id_emp_matriz) then
                
                for _filial in
                    select id_part
                    from tb_part
                    where
                        tp_part like '%[E]%' and
                        id_part <> new.id_emp
                loop
                    update tb_item_emp set
                        vl_cst_med = new.vl_cst_med,
                        vl_cst_rep = new.vl_cst_rep,
                        vl_ult_cst_med = new.vl_ult_cst_med,
                        dt_ult_cmp = new.dt_ult_cmp,
                        vl_prc_vnd = new.vl_prc_vnd,
                        vl_estq_min = new.vl_estq_min,
                        vl_estq_max = new.vl_estq_max,
                        ender_estq = new.ender_estq,
                        vl_perc_luc = new.vl_perc_luc,
                        vl_out = new.vl_out,
                        vl_perc_desp_op = new.vl_perc_desp_op,
                        vl_desp_op = new.vl_desp_op,
                        vl_luc = new.vl_luc,
                        vl_ult_prc_vnd = new.vl_ult_prc_vnd,
                        vl_ult_cst_rep = new.vl_ult_cst_rep,
                        dt_hr_ult_alt = new.dt_hr_ult_alt,
                        id_usr_ult_alt = new.id_usr_ult_alt
                    where
                        id_item = new.id_item and
                        id_emp = _filial.id_part;
                        
                    if not found then
                        insert into tb_item_emp 
                            (id_item, id_emp, vl_cst_med, vl_cst_rep, vl_ult_cst_med, dt_ult_cmp,
                             vl_prc_vnd, vl_estq_min, vl_estq_max, ender_estq, vl_perc_luc, vl_out,
                             vl_perc_desp_op, vl_desp_op, vl_luc, vl_ult_prc_vnd, vl_ult_cst_rep,
                             dt_hr_ult_alt, id_usr_ult_alt)
                        values
                            (new.id_item, _filial.id_part, new.vl_cst_med, new.vl_cst_rep, new.vl_ult_cst_med, new.dt_ult_cmp,
                             new.vl_prc_vnd, new.vl_estq_min, new.vl_estq_max, new.ender_estq, new.vl_perc_luc, new.vl_out,
                             new.vl_perc_desp_op, new.vl_desp_op, new.vl_luc, new.vl_ult_prc_vnd, new.vl_ult_cst_rep,
                             new.dt_hr_ult_alt, new.id_usr_ult_alt);
                    end if;
                end loop;
                
            end if;
        end if;
    end if;



    if (tg_op = 'UPDATE') then
        if (old.vl_cst_med <> new.vl_cst_med or
            old.vl_cst_rep <> new.vl_cst_rep or
            old.vl_prc_vnd <> new.vl_prc_vnd) then

            insert into tb_item_alt_prc
                (id_emp, id_item_alt_prc, id_item, dt_hr, 
                 vl_cst_rep_ant, vl_cst_rep_atu, 
                 vl_cst_med_ant, vl_cst_med_atu, 
                 vl_prc_vnd_ant, vl_prc_vnd_atu,
                 dt_hr_ult_alt, id_usr_ult_alt, id_est_ult_alt)
            values 
                (new.id_emp, nextval('sq_item_alt_prc'), new.id_item, current_timestamp,
                 old.vl_cst_rep, new.vl_cst_rep,
                 old.vl_cst_med, new.vl_cst_med,
                 old.vl_prc_vnd, new.vl_prc_vnd,
                 new.dt_hr_ult_alt, new.id_usr_ult_alt, new.id_est_ult_alt);


            -- Busca o campo unitario do item agregado
            select fc_get_emp_cnf(new.id_emp, 07016) into _cmp_prc_unt_item_agr; -- CNF_ITEM_PRC_UNT_ITEM_AGR

            -- 
            -- Altera o preco unitario do item agregado que este item compoe
            --
            update tb_item_agr set
                vl_unt = 
                    case _cmp_prc_unt_item_agr 
                        when 'vl_prc_vnd' then new.vl_prc_vnd
                        when 'vl_cst_med' then new.vl_cst_med
                        else new.vl_cst_rep
                    end,
                vl_tot = vl_qtd *
                    case _cmp_prc_unt_item_agr 
                        when 'vl_prc_vnd' then new.vl_prc_vnd
                        when 'vl_cst_med' then new.vl_cst_med
                        else new.vl_cst_rep
                    end,
                dt_hr_ult_alt = new.dt_hr_ult_alt,
                id_usr_ult_alt = new.id_usr_ult_alt
            where
                id_item_agr = new.id_item;
        end if;
    end if;
    
    return new;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_nf_at_prc (
  _id_emp integer,
  _id_nf integer,
  _alt_prc_vnd boolean,
  _alt_prc_cst boolean
)
RETURNS boolean AS
$body$
declare
    _nf record;
    _nf_item_list refcursor;
    _nf_item record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
    
begin
    select * into _nf
    from tb_nf
    where
        id_emp = _id_emp and
        id_nf = _id_nf;
        
        
    if (_nf.tp_emis = '[T]') then
        
        select * into _nat_op
        from tb_nat_op
        where
            id_nat_op = _nf.id_nat_op;
            
            
        open _nf_item_list for 
            select *
            from tb_nf_item
            where
                id_emp = _id_emp and
                id_nf = _id_nf;
        
        fetch _nf_item_list into _nf_item;
        
        while found loop
        
            if (_nf_item.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_CST]%') or (_alt_prc_cst) then
                update tb_item_emp set
                    vl_cst_rep = _nf_item.vl_cst_rep,
                    vl_cst_med = _nf_item.vl_cst_med,
                    dt_ult_cmp = _nf.dt_op,
                    id_usr_ult_alt = _nf_item.id_usr_ult_alt,
                    dt_hr_ult_alt = _nf_item.dt_hr_ult_alt
                where
                    id_emp = _nf_item.id_emp and
                    id_item = _nf_item.id_item;
            end if;
                
            if (_nf_item.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_VND]%') or (_alt_prc_vnd) then
                update tb_item_emp set
                    vl_out = _nf_item.vl_out_prc,
                    vl_perc_desp_op = _nf_item.vl_perc_desp_op_prc,
                    vl_desp_op = _nf_item.vl_desp_op_prc,
                    vl_perc_luc = _nf_item.vl_perc_luc_prc,
                    vl_luc = _nf_item.vl_luc_prc,
                    vl_prc_vnd = _nf_item.vl_prc_vnd,
                    id_usr_ult_alt = _nf_item.id_usr_ult_alt,
                    dt_hr_ult_alt = _nf_item.dt_hr_ult_alt
                where
                    id_emp = _nf_item.id_emp and
                    id_item = _nf_item.id_item;
            end if;
        
        
            fetch _nf_item_list into _nf_item;
            
        end loop;
            
    end if;
    
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

