CREATE OR REPLACE FUNCTION public.fc_dt (
  p_d integer,
  p_m integer,
  p_y integer
)
RETURNS date AS
$body$
declare
    _first_date date;
    _last_date date;
begin
    _first_date := cast(p_y || '-' || p_m || '-01' as date);
    
    _last_date := (date_trunc('month', _first_date) + interval '1 month' - interval '1 day')::date;
    
    if (p_d > extract(day from _last_date)) then
        return _last_date;
    else
        return cast(p_y || '-' || p_m || '-' || p_d as date);
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;