ALTER TABLE public.tb_nat_op
  ADD COLUMN obs_cte VARCHAR(2000);

ALTER TABLE public.tb_nat_op
  ADD COLUMN cd_icms_cte VARCHAR(5);

ALTER TABLE public.tb_nat_op
  ADD COLUMN id_cfop_cte INTEGER;

ALTER TABLE public.tb_disp
  ADD COLUMN exib BOOLEAN;

ALTER TABLE public.tb_disp
  ADD COLUMN vl_max NUMERIC(12,4);

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_calc_ir (
  _id_part integer,
  _dt date,
  _vl numeric
)
RETURNS numeric AS
$body$
declare
    _qtd_depend integer;
    _vl_abat_ir numeric;
    _vl_bc_ir numeric;
    _vl_ir numeric;
    _part record;
    _vl_depend numeric;
begin
    
    select count(*) into _qtd_depend
    from tb_part_cred
    where
        id_part = _id_part;
        
    select 
        distinct tb_ir.vl_depend 
    into _vl_depend
    from tb_ir
    where
        _dt between tb_ir.dt_i and tb_ir.dt_f;
        

    select
        tb_part.id_part,
        tb_part.vl_pa,
        tb_grp_disp.vl_perc_bc_ir,
        sum(
            case 
                when tb_disp.tp = 'V' then tb_grp_disp_item.vl_disp
                when (_vl * tb_grp_disp_item.vl_disp / 100 > tb_disp.vl_max) then tb_disp.vl_max
                else _vl * tb_grp_disp_item.vl_disp / 100
            end 
        ) as vl_abat_ir
    into
        _part
    from tb_part
    join tb_grp_disp on
        (tb_part.id_grp_disp = tb_grp_disp.id_grp_disp)
    join tb_grp_disp_item on
        (tb_part.id_grp_disp = tb_grp_disp_item.id_grp_disp)
    join tb_disp on
        (tb_grp_disp_item.id_disp = tb_disp.id_disp)
    where 
        tb_part.id_part = _id_part and
        tb_disp.abat_ir
    group by
        tb_part.id_part,
        tb_part.vl_pa,
        tb_grp_disp.vl_perc_bc_ir;
        
    
    
    _vl_bc_ir := cast(coalesce(_vl * _part.vl_perc_bc_ir / 100, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - coalesce(_part.vl_pa, 0);
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - cast(coalesce(_vl_depend * _qtd_depend, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - cast(coalesce(_part.vl_abat_ir, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;

    
    select
        (_vl_bc_ir * tb_ir.vl_aliq / 100) - tb_ir.vl_ded
    into
        _vl_ir
    from tb_ir
    where
        _dt between tb_ir.dt_i and tb_ir.dt_f and
        _vl_bc_ir between tb_ir.vl_i and tb_ir.vl_f;

    return _vl_ir;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_rom_frete
  ALTER COLUMN dist TYPE NUMERIC(12,4);

ALTER TABLE public.tb_rom_frete
  ALTER COLUMN obs TYPE VARCHAR(2000) COLLATE pg_catalog."default";

ALTER TABLE public.tb_rom_frete
  ADD COLUMN id_nat_op INTEGER;

ALTER TABLE public.tb_veic
  RENAME COLUMN placa_car TO placa_reb_1;

ALTER TABLE public.tb_veic
  ADD COLUMN placa_reb_dolly VARCHAR(10);

ALTER TABLE public.tb_veic
  ADD COLUMN placa_reb_2 VARCHAR(10);

ALTER TABLE public.tb_cte
  ALTER COLUMN obs TYPE VARCHAR(2000) COLLATE pg_catalog."default";

ALTER TABLE public.tb_cte
  ADD COLUMN id_nat_op INTEGER;

ALTER TABLE public.tb_bx_ct_disp
  ADD COLUMN vl_disp_exib NUMERIC(12,4);

ALTER TABLE public.tb_cte
  DROP COLUMN nat_op;

ALTER TABLE public.tb_rom_frete
  ADD CONSTRAINT fk__rom_frete__nat_op FOREIGN KEY (id_nat_op)
    REFERENCES public.tb_nat_op(id_nat_op)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte
  ADD CONSTRAINT fk__cte__nat_op FOREIGN KEY (id_nat_op)
    REFERENCES public.tb_nat_op(id_nat_op)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

