CREATE SEQUENCE public.sq_req_colab
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_req_colab_parc_forn_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _req_colab record;
BEGIN
    select * into _op_fnc
    from tb_op_fnc
    where
        tp_op_fnc = 'DUP'
    limit 1;
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'REQ_COLAB.FORN.' || old.id_req_colab || '.' || new.id_req_colab_parc_forn;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _req_colab
        from tb_req_colab
        where
            id_emp = new.id_emp and
            id_req_colab = new.id_req_colab;
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, id_op_fnc, vl_quit, vl_rest, 
             -- id_plano_ct,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _req_colab.id_forn, new.id_req_colab, new.id_req_colab_parc_forn, new.qtd_parc,
             _req_colab.dt_req_colab, new.dt_venc, new.vl_parc, 'P', 
             'REQ_COLAB.FORN.' || new.id_req_colab || '.' || new.id_req_colab_parc_forn, _op_fnc.id_op_fnc, 0, new.vl_parc, 
             -- new.id_plano_ct,
             new.vl_parc, 0, 0, 0, 0, 
             _req_colab.id_usr_ult_alt, _req_colab.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_req_colab_parc_colab_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _req_colab record;
BEGIN
    select * into _op_fnc
    from tb_op_fnc
    where
        tp_op_fnc = 'DUP'
    limit 1;
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'REQ_COLAB.COLAB.' || old.id_req_colab || '.' || new.id_req_colab_parc_colab;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _req_colab
        from tb_req_colab
        where
            id_emp = new.id_emp and
            id_req_colab = new.id_req_colab;
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, id_op_fnc, vl_quit, vl_rest, 
             -- id_plano_ct,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _req_colab.id_colab, new.id_req_colab, new.id_req_colab_parc_colab, new.qtd_parc,
             _req_colab.dt_req_colab, new.dt_venc, new.vl_parc, 'P', 
             'REQ_COLAB.' || new.id_req_colab || '.' || new.id_req_colab_parc_colab, _op_fnc.id_op_fnc, 0, new.vl_parc, 
             -- new.id_plano_ct,
             new.vl_parc, 0, 0, 0, 0, 
             _req_colab.id_usr_ult_alt, _req_colab.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_req_colab (
  id_emp INTEGER NOT NULL, 
  id_req_colab INTEGER NOT NULL, 
  id_colab INTEGER, 
  id_veic INTEGER, 
  id_forn INTEGER, 
  obs VARCHAR(255), 
  vl_tot NUMERIC(12,4), 
  dt_req_colab DATE, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_req_colab PRIMARY KEY(id_emp, id_req_colab)
) ;

CREATE TABLE public.tb_req_colab_parc_colab (
  id_emp INTEGER NOT NULL, 
  id_req_colab INTEGER NOT NULL, 
  id_req_colab_parc_colab INTEGER NOT NULL, 
  dt_venc DATE, 
  vl_parc NUMERIC(12,4), 
  qtd_parc INTEGER, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_req_colab_parc_colab PRIMARY KEY(id_emp, id_req_colab, id_req_colab_parc_colab)
) ;

CREATE TRIGGER tr_req_colab_parc_colab_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_req_colab_parc_colab FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_req_colab_parc_colab_bf();

CREATE TABLE public.tb_req_colab_parc_forn (
  id_emp INTEGER NOT NULL, 
  id_req_colab INTEGER NOT NULL, 
  id_req_colab_parc_forn INTEGER NOT NULL, 
  dt_venc DATE, 
  vl_parc NUMERIC(12,4), 
  qtd_parc INTEGER, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_req_colab_parc_forn PRIMARY KEY(id_emp, id_req_colab, id_req_colab_parc_forn)
) ;

CREATE TRIGGER tr_req_colab_parc_forn_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_req_colab_parc_forn FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_req_colab_parc_forn_bf();

CREATE TABLE public.tb_req_colab_item (
  id_emp INTEGER NOT NULL, 
  id_req_colab INTEGER NOT NULL, 
  id_req_colab_item INTEGER NOT NULL, 
  id_item INTEGER, 
  vl_qtd NUMERIC(12,4), 
  vl_unt NUMERIC(12,4), 
  vl_tot NUMERIC(12,4), 
  km NUMERIC(12,4), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_req_colab_item PRIMARY KEY(id_emp, id_req_colab, id_req_colab_item)
) ;

ALTER TABLE public.tb_req_colab_parc_forn
  ADD CONSTRAINT fk__req_colab_parc_forn___req_colab FOREIGN KEY (id_emp, id_req_colab)
    REFERENCES public.tb_req_colab(id_emp, id_req_colab)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_req_colab_parc_colab
  ADD CONSTRAINT fk__req_colab_parc_colab___req_colab FOREIGN KEY (id_emp, id_req_colab)
    REFERENCES public.tb_req_colab(id_emp, id_req_colab)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_req_colab_item
  ADD CONSTRAINT fk__req_colab_item__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_req_colab_item
  ADD CONSTRAINT fk__req_colab_item__req_colab FOREIGN KEY (id_emp, id_req_colab)
    REFERENCES public.tb_req_colab(id_emp, id_req_colab)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_req_colab
  ADD CONSTRAINT fk__req_colab__colab FOREIGN KEY (id_colab)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_req_colab
  ADD CONSTRAINT fk__req_colab__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_req_colab
  ADD CONSTRAINT fk__req_colab__forn FOREIGN KEY (id_forn)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_req_colab
  ADD CONSTRAINT fk__req_colab__veic FOREIGN KEY (id_veic)
    REFERENCES public.tb_veic(id_veic)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

