CREATE SEQUENCE public.sq_recibo
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_recibo RESTART WITH 4;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
begin
    _app_con := fc_app_con();
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        /*
        if (new.vl_rest > 0) then
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            order by
                id_op_fnc
            limit 1;
            
            insert into tb_ct
                (id_emp, id_ct, tp_ct, id_part, parc, qtd_parc, 
                 dt_emis, dt_venc,
                 vl_ct, obs, stat, tp_doc, 
                 org, id_op_fnc, 
                 vl_quit, vl_rest)
            values
                (new.id_emp, nextval('sq_ct'), new.tp_bx, new.id_part, 1, 1,
                new.dt_bx, new.dt_bx,
                new.vl_rest, 'RESTANTE BAIXA ' || new.id_bx_ct, 'P', 'DUP',
                'BX.' || new.id_bx_ct, _op_fnc.id_op_fnc,
                0, new.vl_rest);
        end if;
        */
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
    
        /*
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct;
          */  
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org like 'BX.' || old.id_bx_ct || '%';
            
        delete from tb_recibo
        where
            id_emp = old.id_emp and
            org like 'BX.' || old.id_bx_ct || '%';
            
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_recibo (
  id_emp INTEGER NOT NULL, 
  id_recibo INTEGER NOT NULL, 
  tp_recibo VARCHAR(1), 
  dt_recibo DATE, 
  vl_recibo NUMERIC(12,4), 
  nome_pag VARCHAR(255), 
  descr VARCHAR(255), 
  id_munic INTEGER, 
  nome_rec VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  org VARCHAR(30), 
  CONSTRAINT pk_recibo PRIMARY KEY(id_emp, id_recibo)
) ;

ALTER TABLE public.tb_recibo
  ADD CONSTRAINT fk__recibo__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_recibo
  OWNER TO postgres;

