CREATE OR REPLACE FUNCTION public.fc_item_hist_prc (
  _id_item integer,
  _id_emp integer,
  _id_usr integer,
  _vl_cst_rep numeric,
  _vl_cst_rep_ant numeric,
  _vl_cst_med numeric,
  _vl_cst_med_ant numeric,
  _vl_vnd numeric,
  _vl_vnd_ant numeric
)
RETURNS boolean AS
$body$
declare
    _vl_cst_rep_dif numeric;
    _vl_perc_cst_rep_dif numeric;
    
    _vl_cst_med_dif numeric;
    _vl_perc_cst_med_dif numeric;
    
    _vl_vnd_dif numeric;
    _vl_perc_vnd_dif numeric;
    
    _result numeric[];
begin
    select
        case when (_vl_cst_rep_ant <= 0) then tb_item_emp.vl_cst_rep
            else _vl_cst_rep_ant
        end as vl_cst_rep_ant,
        case when (_vl_cst_med_ant <= 0) then tb_item_emp.vl_cst_med
            else _vl_cst_med_ant
        end as vl_cst_med_ant,
        case when (_vl_vnd_ant <= 0) then tb_item_emp.vl_prc_vnd
            else _vl_vnd_ant
        end as vl_vnd_ant
    into
        _vl_cst_rep_ant,
        _vl_cst_med_ant,
        _vl_vnd_ant
    from tb_item_emp
    where
        tb_item_emp.id_item = _id_item and
        tb_item_emp.id_emp = _id_emp;
        
    
    _vl_cst_rep := coalesce(_vl_cst_rep, 0);
    _vl_cst_rep_ant := coalesce(_vl_cst_rep_ant, 0);
    _vl_cst_med := coalesce(_vl_cst_med, 0);
    _vl_cst_med_ant := coalesce(_vl_cst_med_ant, 0);
    
    if (_vl_cst_rep <> _vl_cst_rep_ant) or (_vl_cst_med <> _vl_cst_med_ant) then
    
        select fc_calc_dif(_vl_cst_rep_ant, _vl_cst_rep) into _result;
        _vl_cst_rep_dif := _result[1];
        _vl_perc_cst_rep_dif := _result[2];

        select fc_calc_dif(_vl_cst_med_ant, _vl_cst_med) into _result;
        _vl_cst_med_dif := _result[1];
        _vl_perc_cst_med_dif := _result[2];
        
        
        insert into tb_item_hist_cst
            (id_item, id_emp, id_item_hist_cst, dt_hr, id_usr,
             vl_cst_rep_atu, vl_cst_rep_ant, vl_cst_rep_dif, vl_perc_cst_rep_dif,
             vl_cst_med_atu, vl_cst_med_ant, vl_cst_med_dif, vl_perc_cst_med_dif)
        values
            (_id_item, _id_emp, nextval('sq_item_hist_cst'), current_timestamp, _id_usr,
             _vl_cst_rep, _vl_cst_rep_ant, _vl_cst_rep_dif, _vl_perc_cst_rep_dif,
             _vl_cst_med, _vl_cst_med_ant, _vl_cst_med_dif, _vl_perc_cst_med_dif);
    end if;
    
    if (_vl_vnd <> _vl_vnd_ant) then
        select fc_calc_dif(_vl_vnd_ant, _vl_vnd) into _result;
        _vl_vnd_dif := _result[1];
        _vl_perc_vnd_dif := _result[2];
        
        insert into tb_item_hist_vnd
            (id_item, id_emp, id_item_hist_vnd, dt_hr, id_usr,
             vl_vnd_atu, vl_vnd_ant, vl_vnd_dif, vl_perc_vnd_dif)
        values
            (_id_item, _id_emp, nextval('sq_item_hist_vnd'), current_timestamp, _id_usr,
             _vl_vnd, _vl_vnd_ant, _vl_vnd_dif, _vl_perc_vnd_dif);
    end if;
    
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

