CREATE OR REPLACE FUNCTION public.fc_tr_mnt_estq_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
--    _app_con varchar;
    _op varchar;
    _upd_op varchar;
BEGIN
--    _app_con := fc_app_con();
    
--    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
            if (lower(old.op) <> 'i') then
                _upd_op := ifthen(lower(old.op) = 'e', 's', 'e');
                
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep_dst, old.id_grd_estq, _upd_op, old.vl_qtd_mov);
                
                if (old.id_dep_org is not null) then
                    perform fc_item_estq(old.id_item, old.id_emp, old.id_dep_org, old.id_grd_estq, old.op, old.vl_qtd_mov);
                end if;
            end if;
        end if;
        
        
        if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
            if (lower(new.op) <> 'i') then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep_dst, new.id_grd_estq, new.op, new.vl_qtd_mov);
                    
                if (new.id_dep_org is not null) then
                    perform fc_item_estq(new.id_item, new.id_emp, new.id_dep_org, new.id_grd_estq, 's', new.vl_qtd_mov);
                end if;
            end if;
            
            if (lower(new.op) = 'e') then
                if not exists(select 1 
                              from tb_item_cd_bar 
                              where
                                  id_item = new.id_item and
                                  id_grd_estq = new.id_grd_estq)  and
                    exists (select 1
                            from tb_grd_estq
                            where
                                id_grd_estq = new.id_grd_estq and
                                gera_cd_bar) then
                    insert into tb_item_cd_bar
                        (id_item, cd_bar, id_grd_estq)
                    values
                        (new.id_item, new.id_item || lpad(new.id_grd_estq, 6, '0'), new.id_grd_estq);
                end if;
            end if;
        end if;
--    end if;
    
    return new;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

