CREATE SEQUENCE public.sq_entr
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE OR REPLACE FUNCTION public.fc_tr_entr_item_bf (
)
RETURNS trigger AS
$body$
begin

    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        if (tg_op = 'UPDATE') then
            if (new.vl_qtd <> old.vl_qtd) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd);
            end if;
            
            if (new.vl_qtd <> old.vl_qtd) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd);
            end if;
        end if;
        
        
        if (tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd);
        end if;
        
        return new;
    
    elsif (tg_op = 'DELETE') then
        
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd);
        
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

ALTER TABLE public.tb_sis_proc
  ADD COLUMN res TEXT;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_item_bf (
)
RETURNS trigger AS
$body$
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
            end if;
            
            if (new.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
            end if;
        end if;
        
        
        if (new.mov_estq and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
        end if;
        
        return new;
    
    elsif (tg_op = 'DELETE') then
        
        if (old.mov_estq) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_entr (
  id_emp INTEGER NOT NULL, 
  id_entr INTEGER NOT NULL, 
  dt_entr DATE, 
  id_cli INTEGER, 
  id_func INTEGER, 
  receb VARCHAR(150), 
  fone VARCHAR(20), 
  cep VARCHAR(10), 
  logr VARCHAR(255), 
  num VARCHAR(20), 
  compl VARCHAR(255), 
  bairro VARCHAR(255), 
  id_munic INTEGER, 
  obs VARCHAR(255), 
  sit VARCHAR(1), 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  CONSTRAINT pk_entr PRIMARY KEY(id_emp, id_entr)
) ;



CREATE TABLE public.tb_entr_item (
  id_emp INTEGER NOT NULL, 
  id_entr INTEGER NOT NULL, 
  id_entr_item INTEGER NOT NULL, 
  id_vnd INTEGER, 
  id_item INTEGER, 
  id_dep INTEGER, 
  id_grd_estq VARCHAR(20), 
  vl_qtd NUMERIC(12,4), 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  CONSTRAINT pk_entr_item PRIMARY KEY(id_emp, id_entr, id_entr_item)
) ;

CREATE TRIGGER tr_entr_item_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_entr_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_entr_item_bf();


ALTER TABLE public.tb_vnd
  ADD COLUMN tp_ret VARCHAR(5);

ALTER TABLE public.tb_entr_item
  ADD CONSTRAINT fk__entr_item__dep FOREIGN KEY (id_emp, id_dep)
    REFERENCES public.tb_dep(id_emp, id_dep)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_entr_item
  ADD CONSTRAINT fk__entr_item__entr FOREIGN KEY (id_emp, id_entr)
    REFERENCES public.tb_entr(id_emp, id_entr)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_entr_item
  ADD CONSTRAINT fk__entr_item__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_entr_item
  ADD CONSTRAINT fk__entr_item__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_entr_item
  ADD CONSTRAINT fk__entr_item__vnd FOREIGN KEY (id_emp, id_vnd)
    REFERENCES public.tb_vnd(id_emp, id_vnd)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_entr
  ADD CONSTRAINT fk__entr__cli FOREIGN KEY (id_cli)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_entr
  ADD CONSTRAINT fk__entr__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_entr
  ADD CONSTRAINT fk__entr__func FOREIGN KEY (id_func)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_entr
  ADD CONSTRAINT fk__entr__munic FOREIGN KEY (id_munic)
    REFERENCES public.tb_munic(id_munic)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_entr
  OWNER TO postgres;

ALTER TABLE public.tb_entr_item
  OWNER TO postgres;


