CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name,
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
    _log_tab boolean;
    _pk varchar[];
begin
    select _tab in (
        'tb_bairro',
        'tb_bnc',
        'tb_cfop',
        'tb_cnae',
        'tb_cnt_bnc',
        'tb_cond_pagto',
        'tb_conv',
        'tb_cx',
        'tb_dep',
        'tb_est',
        'tb_grd_estq',
        'tb_grp_cfop',
        'tb_grp_item',
        'tb_grp_trib',
        'tb_grp_usr',
        'tb_item',
        'tb_item_emp',
        'tb_item_estq',
        'tb_logr',
        'tb_marca',
        'tb_mod_frete',
        'tb_mod_nf',
        'tb_mtv_dev_ch',
        'tb_munic',
        'tb_nat_op',
        'tb_ncm',
        'tb_op_fnc',
        'tb_org_icms',
        'tb_prod_anp',
        'tb_reg_trib',
        'tb_rel',
        'tb_rota',
        'tb_serv',
        'tb_sis_lay',
        'tb_sis_valid',
        'tb_sis_ct',
        'tb_tp_item',
        'tb_trib_cofins',
        'tb_trib_icms',
        'tb_trib_ipi',
        'tb_trib_pis',
        'tb_uf',
        'tb_und_med',
        'tb_usr',
        'tb_ped',
        'tb_mnt_estq',
        'tb_email',
        'tb_mov_bnc',
        'tb_mov_cx',
        'tb_mov_fnc',
        'tb_vnd',
        'tb_part',
        'tb_ct',
        'tb_bx_ct',
        'tb_nf',
        'tb_nfe',
        'tb_carreg',
        'tb_plano_ct',
        'tb_pt_prc'
    ) into _log_tab;
    
    
    delete from tb_sis_uni
    where
        tab = _tab;


    if (_log_tab and _install) then
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        execute 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log after insert or update or delete ' ||
            ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';

        perform fc_add_col('public.' || _tab, 'dt_hr_ult_alt', 'timestamp');
        
        select
            array(
                select 
                    cast(c.column_name as varchar)
                from information_schema.table_constraints tc
                join information_schema.constraint_column_usage as ccu using 
                    (constraint_schema, constraint_name)
                join information_schema.columns as c on 
                    (c.table_schema = tc.constraint_schema and 
                     tc.table_name = c.table_name and 
                     ccu.column_name = c.column_name)
                where 
                    constraint_type = 'PRIMARY KEY' and
                    tc.table_name = _tab
                )
        into _pk;
        
        insert into tb_sis_uni
            (tab, pk)
        values
            (_tab, _pk);
        
        
        return true;
    else 
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;
