ALTER TABLE public.tb_part
  ADD COLUMN tp_emp VARCHAR(1);

ALTER TABLE public.tb_sis_ct
  ADD CONSTRAINT pk_sis_ct 
    PRIMARY KEY (id_emp, id_ct);

	
DROP TRIGGER tr_item_emp_bf ON public.tb_item_emp;

ALTER TABLE public.tb_item_und_med
  DROP CONSTRAINT k__item_und_med__item RESTRICT;

ALTER TABLE public.tb_item_emp
  DROP CONSTRAINT tfk__item_prc_cst__emp RESTRICT;

ALTER TABLE public.tb_item_emp
  DROP CONSTRAINT k__item_prc_cst__item RESTRICT;

CREATE OR REPLACE FUNCTION public.fc_id_emp_matriz (
)
RETURNS integer AS
$body$
select id_part
from tb_part
where
    tp_emp = 'M'
order by 
    id_part
limit 1
$body$
LANGUAGE 'sql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name,
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
    _log_tab boolean;
    _pk varchar[];
begin
    select _tab in (
        'tb_bairro',
        'tb_bnc',
        'tb_cfop',
        'tb_cnae',
        'tb_cnt_bnc',
        'tb_cond_pagto',
        'tb_conv',
        'tb_cx',
        'tb_dep',
        'tb_est',
        'tb_grd_estq',
        'tb_grp_cfop',
        'tb_grp_item',
        'tb_grp_trib',
        'tb_grp_usr',
        'tb_item',
        'tb_item_emp',
        'tb_item_estq',
        'tb_logr',
        'tb_marca',
        'tb_mod_frete',
        'tb_mod_nf',
        'tb_mtv_dev_ch',
        'tb_munic',
        'tb_nat_op',
        'tb_ncm',
        'tb_op_fnc',
        'tb_org_icms',
        'tb_prod_anp',
        'tb_reg_trib',
        'tb_rel',
        'tb_rota',
        'tb_serv',
        'tb_sis_lay',
        'tb_sis_valid',
        'tb_sis_ct',
        'tb_tp_item',
        'tb_trib_cofins',
        'tb_trib_icms',
        'tb_trib_ipi',
        'tb_trib_pis',
        'tb_uf',
        'tb_und_med',
        'tb_usr',
        'tb_ped',
        'tb_mnt_estq',
        'tb_email',
        'tb_mov_bnc',
        'tb_mov_cx',
        'tb_mov_fnc',
        'tb_vnd',
        'tb_part',
        'tb_ct',
        'tb_bx_ct',
        'tb_nf',
        'tb_nfe',
        'tb_carreg'
    ) into _log_tab;
    
    
    delete from tb_sis_uni
    where
        tab = _tab;


    if (_log_tab and _install) then
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        execute 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log after insert or update or delete ' ||
            ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';

        perform fc_add_col('public.' || _tab, 'dt_hr_ult_alt', 'timestamp');
        
        select
            array(
                select 
                    cast(c.column_name as varchar)
                from information_schema.table_constraints tc
                join information_schema.constraint_column_usage as ccu using 
                    (constraint_schema, constraint_name)
                join information_schema.columns as c on 
                    (c.table_schema = tc.constraint_schema and 
                     tc.table_name = c.table_name and 
                     ccu.column_name = c.column_name)
                where 
                    constraint_type = 'PRIMARY KEY' and
                    tc.table_name = _tab
                )
        into _pk;
        
        insert into tb_sis_uni
            (tab, pk)
        values
            (_tab, _pk);
        
        
        return true;
    else 
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_item_emp_bf (
)
RETURNS trigger AS
$body$
declare
    _id_emp_matriz integer;
    _cnf_item_alt_prc_filial varchar;
    
    _filial record;
begin
    if (tg_op = 'INSERT') 
        or (tg_op = 'UPDATE'
            and (old.vl_cst_med <> new.vl_cst_med
                 or old.vl_cst_rep <> new.vl_cst_rep
                 or old.vl_prc_vnd <> new.vl_prc_vnd)) then
        --
        -- Altera/Insere os preos nas filiais
        --
        _cnf_item_alt_prc_filial := fc_get_emp_cnf(new.id_emp, 07011);
        
        if (lower(_cnf_item_alt_prc_filial) = 'true') then
            _id_emp_matriz := fc_id_emp_matriz();
            if (new.id_emp = _id_emp_matriz) then
                
                for _filial in
                    select id_part
                    from tb_part
                    where
                        tp_part like '%[E]%' and
                        id_part <> new.id_emp
                loop
                    update tb_item_emp set
                        vl_cst_med = new.vl_cst_med,
                        vl_cst_rep = new.vl_cst_rep,
                        vl_ult_cst_med = new.vl_ult_cst_med,
                        dt_ult_cmp = new.dt_ult_cmp,
                        vl_prc_vnd = new.vl_prc_vnd,
                        vl_estq_min = new.vl_estq_min,
                        vl_estq_max = new.vl_estq_max,
                        ender_estq = new.ender_estq,
                        vl_perc_luc = new.vl_perc_luc,
                        vl_out = new.vl_out,
                        vl_perc_desp_op = new.vl_perc_desp_op,
                        vl_desp_op = new.vl_desp_op,
                        vl_luc = new.vl_luc,
                        vl_ult_prc_vnd = new.vl_ult_prc_vnd,
                        vl_ult_cst_rep = new.vl_ult_cst_rep,
                        dt_hr_ult_alt = new.dt_hr_ult_alt
                    where
                        id_item = new.id_item and
                        id_emp = _filial.id_part;
                        
                    if not found then
                        insert into tb_item_emp 
                            (id_item, id_emp, vl_cst_med, vl_cst_rep, vl_ult_cst_med, dt_ult_cmp,
                             vl_prc_vnd, vl_estq_min, vl_estq_max, ender_estq, vl_perc_luc, vl_out,
                             vl_perc_desp_op, vl_desp_op, vl_luc, vl_ult_prc_vnd, vl_ult_cst_rep,
                             dt_hr_ult_alt)
                        values
                            (new.id_item, _filial.id_part, new.vl_cst_med, new.vl_cst_rep, new.vl_ult_cst_med, new.dt_ult_cmp,
                             new.vl_prc_vnd, new.vl_estq_min, new.vl_estq_max, new.ender_estq, new.vl_perc_luc, new.vl_out,
                             new.vl_perc_desp_op, new.vl_desp_op, new.vl_luc, new.vl_ult_prc_vnd, new.vl_ult_cst_rep,
                             new.dt_hr_ult_alt);
                    end if;
                end loop;
                
            end if;
        end if;
    end if;



    if (tg_op = 'UPDATE') then
        if (old.vl_cst_med <> new.vl_cst_med or
            old.vl_cst_rep <> new.vl_cst_rep or
            old.vl_prc_vnd <> new.vl_prc_vnd) then

            insert into tb_item_alt_prc
                (id_emp, id_item_alt_prc, id_item, dt_hr, 
                 vl_cst_rep_ant, vl_cst_rep_atu, 
                 vl_cst_med_ant, vl_cst_med_atu, 
                 vl_prc_vnd_ant, vl_prc_vnd_atu)
            values 
                (new.id_emp, nextval('sq_item_alt_prc'), new.id_item, current_timestamp,
                 old.vl_cst_rep, new.vl_cst_rep,
                 old.vl_cst_med, new.vl_cst_med,
                 old.vl_prc_vnd, new.vl_prc_vnd);

        end if;
    end if;
    
    return new;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _nf record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;
        
        
        
        if (_nf.tp_op = '[E]') then
            _op := 'E';
            _op_inv := 'S';
        else
            _op := 'S';
            _op_inv := 'E';
        end if;
        
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
            end if;
            
            if (new.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
        end if;
        
        
            
        if (_nf.tp_emis = '[T]') then
        
            select * into _nat_op
            from tb_nat_op
            where
                id_nat_op = _nf.id_nat_op;
            
            if (_nat_op.op like '%[NF_REC__AT_PRC_CST]%') then
                update tb_item_emp set
                    vl_cst_rep = new.vl_cst_rep,
                    vl_cst_med = new.vl_cst_med,
                    dt_ult_cmp = _nf.dt_op
                where
                    id_emp = new.id_emp and
                    id_item = new.id_item;
            end if;
            
            if (new.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_VND]%') then
                update tb_item_emp set
                    vl_out = new.vl_out_prc,
                    vl_perc_desp_op = new.vl_perc_desp_op_prc,
                    vl_desp_op = new.vl_desp_op_prc,
                    vl_perc_luc = new.vl_perc_luc_prc,
                    vl_luc = new.vl_luc_prc,
                    vl_prc_vnd = new.vl_prc_vnd
                where
                    id_emp = new.id_emp and
                    id_item = new.id_item;
            else
                
                
            end if;
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
            
        if (_nf.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
    
        if (found and old.mov_estq) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;


CREATE INDEX idx_part__emp ON public.tb_part
  USING btree (id_part)
  WHERE ((tp_part)::text ~~ '%[E]%'::text);

ALTER TABLE public.tb_item_und_med
  ADD CONSTRAINT fk__item_und_med__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_emp
  ADD CONSTRAINT fk__item_emp__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_emp
  ADD CONSTRAINT fk__item_emp__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_item_emp_bf
  BEFORE INSERT OR UPDATE 
  ON public.tb_item_emp FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_item_emp_bf();

update tb_nat_op set
    op = op || '[NF_REC__AT_PRC_VND][NF_REC__AT_PRC_CST]';
	
update tb_part set
    tp_emp = 'M'
where
    tp_part like '%[E]%';