CREATE OR REPLACE FUNCTION public.fc_tr_mnt_estq_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _app_con varchar;
    _lst_mnt_estq_item refcursor;
    _mnt_estq_item record;
    _op varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (lower(old.op) <> 'i') and (_app_con <> 'NEO_UNI') then
    
        _op := ifthen(lower(old.op) = 't', 'e', lower(old.op));

        open _lst_mnt_estq_item for
            select *
            from tb_mnt_estq_item
            where
                id_emp = old.id_emp and
                id_mnt_estq = old.id_mnt_estq;
        
        fetch _lst_mnt_estq_item into _mnt_estq_item;
        
        while found loop
        
            perform fc_item_estq(_mnt_estq_item.id_item, _mnt_estq_item.id_emp, old.id_dep_dst, _mnt_estq_item.id_grd_estq, _op, _mnt_estq_item.vl_qtd_mov);
            
            if (old.id_dep_org is not null) then
                perform fc_item_estq(_mnt_estq_item.id_item, _mnt_estq_item.id_emp, old.id_dep_org, _mnt_estq_item.id_grd_estq, 'e', _mnt_estq_item.vl_qtd_mov);
            end if;
        
            fetch _lst_mnt_estq_item into _mnt_estq_item;
            
        end loop;
        
    end if;
    
    return old;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_mnt_estq_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _app_con varchar;
    _mnt_estq record;
    _mnt_estq_item record;
    _op varchar;
    _upd_op varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (_app_con <> 'NEO_UNI') then
    
        select * into _mnt_estq 
        from tb_mnt_estq
        where
            tb_mnt_estq.id_emp = new.id_emp and
            tb_mnt_estq.id_mnt_estq = new.id_mnt_estq;

        if (lower(_mnt_estq.op) <> 'i') then
        
            _op := ifthen(lower(_mnt_estq.op) = 't', 'e', lower(_mnt_estq.op));


            if (tg_op = 'UPDATE') then
                
                _upd_op := ifthen(lower(_op) = 'e', 's', 'e');
                

                perform fc_item_estq(old.id_item, old.id_emp, _mnt_estq.id_dep_dst, old.id_grd_estq, _upd_op, old.vl_qtd_mov);
                
                if (_mnt_estq.id_dep_org is not null) then
                    perform fc_item_estq(old.id_item, old.id_emp, _mnt_estq.id_dep_org, old.id_grd_estq, _op, old.vl_qtd_mov);
                end if;
                
            end if;

            
            perform fc_item_estq(new.id_item, new.id_emp, _mnt_estq.id_dep_dst, new.id_grd_estq, _op, new.vl_qtd_mov);
                
            if (_mnt_estq.id_dep_org is not null) then
                perform fc_item_estq(new.id_item, new.id_emp, _mnt_estq.id_dep_org, new.id_grd_estq, 's', new.vl_qtd_mov);
            end if;
            
        end if;
    end if;
    
    return new;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_bf (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _nf_item_list refcursor;
    _nf_item record;
    _op_inv varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (tg_op in ('INSERT', 'UPDATE') ) and (_app_con <> 'NEO_UNI') then
        if (tg_op  = 'INSERT' and new.tp_emis = '[P]' and new.num is null) then
            new.num := fc_get_num_nf(new.id_emp, new.ser);
        end if;
    
    elsif (tg_op = 'DELETE') then
        
        update tb_ped set id_nf = null
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
    
        if (old.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
        
        open _nf_item_list for
            select *
            from tb_nf_item
            where
                id_emp = old.id_emp and
                id_nf = old.id_nf;
    
        fetch _nf_item_list into _nf_item;
        
        
    
        while found loop
            if (_nf_item.mov_estq) then
                perform fc_item_estq(_nf_item.id_item, _nf_item.id_emp, _nf_item.id_dep, _nf_item.id_grd_estq, _op_inv, _nf_item.vl_qtd_mov);
            end if;
            
            fetch _nf_item_list into _nf_item;
        end loop;
        
        close _nf_item_list;
        
        
        if (_app_con <> 'NEO_UNI') then
            delete from tb_mov_fnc
            where
                id_emp = old.id_emp and
                org like 'NF.' || old.id_nf || '%';
        end if;
 
    end if;
    
    
    if (tg_op in ('INSERT', 'UPDATE') ) then
        return new;
    else
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_ped
  ADD COLUMN id_nf INTEGER;

ALTER TABLE public.tb_ped
  ADD CONSTRAINT fk__ped__nf FOREIGN KEY (id_emp, id_nf)
    REFERENCES public.tb_nf(id_emp, id_nf)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

