CREATE OR REPLACE FUNCTION public.fc_tr_log (
)
RETURNS trigger AS
$body$
declare
    _pk varchar[];
    _val varchar[];
    _col_list varchar[];
    _val_list varchar[];
    _id_est integer;
    _i integer;
    _idx integer;
    _count integer;
    _aux varchar;
    
    _dt_hr timestamp;
begin
    select
        array(
            select 
                cast(c.column_name as varchar)
            from information_schema.table_constraints tc
            join information_schema.constraint_column_usage as ccu using 
                (constraint_schema, constraint_name)
            join information_schema.columns as c on 
                (c.table_schema = tc.constraint_schema and 
                 tc.table_name = c.table_name and 
                 ccu.column_name = c.column_name)
            where 
                constraint_type = 'PRIMARY KEY' and
                tc.table_name = tg_table_name
            )
    into _pk;
    
    select
        array(
            select 
                pg_attribute.attname
            from pg_attribute 
            join pg_class on 
                (pg_attribute.attrelid = pg_class.oid) 
            where 
                pg_attribute.attname not in ('oid', 'tableoid', 'cmax', 'xmax', 'cmin', 'xmin', 'ctid') and 
                pg_class.relname = tg_table_name
            order by
                pg_attribute.attnum
        )
    into _col_list;
    
    
    _id_est := fc_id_est_con();
    
    _count := array_upper(_pk, 1);
    
    for _i in 1.._count loop

        if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using new;
        else
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using old;
        end if;
        
        _val[_i] := _aux;
    end loop;
    
    -- if (hstore(new) ? 'dt_hr_ult_alt') then
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        _dt_hr := new.dt_hr_ult_alt;
    else
        _dt_hr := current_timestamp;
    end if;
    -- else
    --    _dt_hr := current_timestamp;
    -- end if;
    
    
    insert into tb_log
        (id_log, org, op, col_pk, val_pk, id_est, dt_hr)
    values
        (nextval('sq_log'), tg_table_name, substring(tg_op, 1, 1), _pk, _val, _id_est, _dt_hr);
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;