CREATE OR REPLACE FUNCTION public.fc_add_col (
  _tbl pg_catalog.regclass,
  _col text,
  _type pg_catalog.regtype
)
RETURNS boolean AS
$body$
begin
    if exists (
        select 1
        from pg_attribute
        where attrelid = _tbl and
              attname = _col and
              not attisdropped) then
          
        return false;

    else
        execute 'alter table ' || _tbl || ' add column ' || quote_ident(_col) || ' ' || _type;
        return true;
    end if;
end
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name,
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
begin
    --tb_emp_cnf
    
    /*
    if (_tab in ('tb_bairro', 'tb_blt', 'tb_blt_ret', 'tb_bnc', 'tb_bnc_blt', 'tb_bx_ct', 
        'tb_cfop', 'tb_ch', 'tb_cnae', 'tb_cnt_bnc', 'tb_cond_pagto', 'tb_conv',
        'tb_ct', 'tb_cx', 'tb_dep', 'tb_emis_blt', 'tb_grd_estq', 
        'tb_grp_cfop', 'tb_grp_item', 'tb_grp_trib', 'tb_grp_usr', 'tb_item',
        'tb_logr', 'tb_marca', 'tb_mnt_estq', 'tb_mod_frete', 'tb_mod_nf', 
        'tb_mov_cx', 'tb_mov_fnc', 'tb_mtv_dev_ch', 'tb_munic', 'tb_nat_op', 
        'tb_ncm', 'tb_nf', 'tb_nfe_dest', 'tb_obj_os', 'tb_op_fnc', 'tb_org_icms', 
        'tb_os', 'tb_part', 'tb_ped', 'tb_prio_os', 'tb_prod_anp', 'tb_reg_trib',
        'tb_rel', 'tb_script', 'tb_serv', 'tb_sis_grid', 'tb_sis_valid', 'tb_tp_item',
        'tb_trib_cofins', 'tb_trib_icms', 'tb_trib_ipi', 'tb_trib_pis', 'tb_uf',
        'tb_und_med', 'tb_usr', 'tb_vnd')
    ) */
    if (_tab not in ('tb_log', 'tb_log_con', 'tb_item_estq', 'tb_lic') and _install) then
    
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;

        _cmd := 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log ';
        
        if (_tab = 'tb_est') then
            _cmd := _cmd || ' after insert or delete ';
        else
            _cmd := _cmd || ' after insert or update or delete ';
        end if;
        
        _cmd := _cmd || ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';
            
        execute _cmd;
        
        perform fc_add_col('public.' || _tab, 'dt_hr_ult_alt', 'timestamp');
            
        return true;
        
    else 
        -- raise notice '%', replace(_tab, 'tb_', 'tr_');
        
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_log_af (
)
RETURNS trigger AS
$body$
declare
    _est_list refcursor;
    _est record;
    _id_est_con integer;
    _tab record;
begin
    
    select 
        tablename, 
        case
            when tablename in ('tb_bairro', 'tb_bnc', 'tb_bnc_blt', 'tb_cfop', 'tb_cnae', 'tb_cnt_bnc',
                'tb_cond_pagto', 'tb_cond_pagto_parc', 'tb_conv', 'tb_cx', 'tb_dep', 'tb_est', 'tb_grd_estq', 
                'tb_grp_cfop', 'tb_grp_cfop_nat_op', 'tb_grp_item', 'tb_grp_trib', 'tb_grp_trib_nat_op', 
                'tb_grp_usr', 'tb_logr', 'tb_marca', 'tb_mod_frete', 'tb_mod_nf', 'tb_mtv_dev_ch', 'tb_munic', 
                'tb_nat_op', 'tb_ncm', 'tb_obj_os', 'tb_op_fnc', 'tb_org_icms', 'tb_prio_os', 'tb_prod_anp',
                'tb_reg_trib', 'tb_rel', 'tb_rel_cab', 'tb_rel_col', 'tb_rel_item', 'tb_rel_item_col', 
                'tb_rel_item_tot', 'tb_rel_tot', 'tb_rota', 'tb_serv', 'tb_sis_grid', 'tb_sis_lay', 
                'tb_sis_valid', 'tb_tp_item', 'tb_trib_cofins',
                'tb_trib_icms', 'tb_trib_ipi', 'tb_trib_pis', 'tb_uf', 'tb_und_med', 
                'tb_usr', 'tb_usr__grp_usr') 
                then 'R1'
            when tablename in ('tb_part', 'tb_part_cond_pagto', 'tb_part_cred', 'tb_part_ender', 'tb_part_obs',
                'tb_part_op_fnc', 'tb_part_ref',
                'tb_item', 'tb_item_cd_bar', 'tb_item_emp', 'tb_item_forn', 'tb_item_und_med', 'tb_ped', 'tb_ped_item')
                then 'R2'
            when tablename in ('tb_emp_cnf', 'tb_item_estq', 'tb_item_prc_vnd_log', 'tb_script', 'tb_lic') 
                then 'N'
            else 'E'
        end as op
    into _tab
    from pg_tables
    where
        tablename = new.org;
    
    
    if (new.id_est is null or (new.id_est <> fc_id_est_local() and new.id_est <> fc_id_est_central() )) and (new.sit is null) and 
        ( (_tab.op in ('R1', 'E') and fc_id_est_local() = fc_id_est_central()) or (_tab.op in ('E', 'R2')) )
    then
        
        _id_est_con := fc_id_est_con();
        
        
        if (fc_id_est_local() <> fc_id_est_central()) then
            open _est_list for
                select *
                from tb_est
                where
                    tb_est.tp_est = 'C';
                    
        elsif (_id_est_con is null) and (_tab.op = 'R2') then
            open _est_list for
                select *
                from tb_est
                where
                    not tb_est.local;
        elsif (_tab.op = 'R1') then
            open _est_list for
                select *
                from tb_est
                where
                    not tb_est.local and
                    tb_est.id_est <> _id_est_con;
        else 
            return null;
        end if;
        
        fetch _est_list into _est;
        
        while found loop
        
            insert into tb_log
                (id_log, org, op, col_pk, val_pk, id_est, dt_hr, sit)
            values
                (nextval('sq_log'), new.org, new.op, new.col_pk, new.val_pk, _est.id_est, new.dt_hr, 'P');
            
            fetch _est_list into _est;
        
        end loop;
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_bairro
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_blt
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_blt_ret
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_bnc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_bnc_blt
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_bx_ct
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_bx_ct__ct
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_bx_ct_pagto
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_cce
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_cfop
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_ch
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_ch_sit
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_cnae
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_cnt_bnc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_cond_pagto
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_cond_pagto_parc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_conv
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_ct
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_cx
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_dep
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_email
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_emis_blt
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_emis_blt_part
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_emp_cnf
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_est
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_grd_estq
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_grp_cfop
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_grp_cfop_nat_op
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_grp_item
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_grp_trib
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_grp_trib_nat_op
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_grp_usr
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_item
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_item_alt_prc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_item_cd_bar
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_item_emp
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_item_forn
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_item_und_med
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_logr
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_marca
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_mnt_estq
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_mnt_estq_item
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_mod_frete
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_mod_nf
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_mov_cx
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_mov_cx__mov_fnc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_mov_cx_apur
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_mov_fnc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_mtv_dev_ch
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_munic
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_nat_op
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_ncm
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_nf
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_nf_item
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_nf_item_grd_estq
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_nf_parc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_nfe
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_nfe_dest
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_nfe_evt
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_obj_os
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_op_fnc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_org_icms
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_os
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_os_evt
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_part
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_part_cond_pagto
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_part_cred
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_part_ender
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_part_obs
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_part_op_fnc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_part_ref
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_ped
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_ped_item
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_prio_os
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_prod_anp
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_reg_trib
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_rel
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_rel_cab
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_rel_col
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_rel_item
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_rel_item_col
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_rel_item_tot
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_rel_tot
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_rom
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_rom_vnd
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_rota
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_script
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_serv
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_sis_grid
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_sis_lay
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_sis_valid
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_tp_item
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_trib_cofins
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_trib_icms
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_trib_ipi
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_trib_pis
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_uf
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_und_med
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_usr
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_usr__grp_usr
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_vnd
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_vnd_item
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_vnd_parc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

CREATE TRIGGER tr_cce_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_cce FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

