CREATE SEQUENCE public.sq_mov_bnc
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_mov_bnc RESTART WITH 8;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_bx_ct = old.id_bx_ct and
            id_bx_ct_pagto = old.id_bx_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
            _id_ch := nextval('sq_ch');
                
            insert into tb_ch
                (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                 dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_bx_ct, id_bx_ct_pagto)
            values
                (new.id_emp, _id_ch, ifthen(_bx_ct.tp_bx = 'R', 'R', 'E'), _bx_ct.id_part, new.emit, new.cpf_cnpj,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_bx_ct, new.id_bx_ct_pagto);
                
            perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'QUITACAO DE DUPLICATA ' || _bx_ct.id_bx_ct);
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            id_nf = old.id_nf and
            id_nf_parc = old.id_nf_parc;

        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_nf = old.id_nf and
            id_nf_parc = old.id_nf_parc;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
                
                
            if (_op_fnc.tp_op_fnc = 'CRED') OR (_op_fnc.tp_op_fnc = 'BLT') then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, id_nf, id_nf_parc)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _nf.id_part_emt, cast(_nf.num as varchar), new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', new.id_nf, new.id_nf_parc);
                     
            elsif (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
                _id_ch := nextval('sq_ch');
                
                insert into tb_ch
                    (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                     dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_nf, id_nf_parc)
                values
                    (new.id_emp, _id_ch, 'E', _nf.id_part_emt, new.emit, new.cpf_cnpj,
                     _nf.dt_op, new.dt_venc, new.vl_parc, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_nf, new.id_nf_parc);
                
                perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'NOTA FISCAL ' || _nf.ser || ' - ' || _nf.num);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_ch
  ADD COLUMN loc VARCHAR(2);

CREATE TABLE public.tb_mov_bnc (
  id_emp INTEGER NOT NULL, 
  id_mov_bnc INTEGER NOT NULL, 
  id_cnt_bnc INTEGER, 
  dt_emis DATE, 
  dt_venc DATE, 
  nr_doc VARCHAR(20), 
  op VARCHAR(1), 
  vl_lanc NUMERIC(12,4), 
  descr VARCHAR(150), 
  conc BOOLEAN, 
  org VARCHAR(30), 
  id_org INTEGER, 
  id_part INTEGER
) WITHOUT OIDS;

ALTER TABLE public.tb_nf_parc
  ADD COLUMN id_cnt_bnc INTEGER;

ALTER TABLE public.tb_mov_bnc
  ADD CONSTRAINT pk_mov_bnc 
    PRIMARY KEY (id_emp, id_mov_bnc);

ALTER TABLE public.tb_nf_parc
  ADD CONSTRAINT fk__nf_parc__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_bnc
  ADD CONSTRAINT fk__mov_bnc__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_bnc
  ADD CONSTRAINT fk__mov_bnc__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_bnc
  ADD CONSTRAINT fk__mov_bnc__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_bx_ct_pagto_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_bx_ct_pagto FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_bx_ct_pagto_bf();

CREATE TRIGGER tr_mov_bnc_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mov_bnc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

