--
-- tb_ct
--
do $$
declare
    _item record;
    _list refcursor;
begin
    if (coalesce(fc_get_emp_cnf(1, 27005), '') <> '') then
        open _list for 
            select
                tb.id
            from
            (
                select generate_series(min(id_ct), max(id_ct)) as id
                from tb_ct

            ) as tb
            where
                not exists 
                (
                    select 1
                    from tb_ct
                    where
                        tb.id = tb_ct.id_ct
                )
                
            order by id;
           
        fetch _list into _item;
        
        while found loop
            
            insert into tb_sinc
                (id_est, op, tb, col_pk, val_pk, dt_hr, id_sinc)
            values
                (1, 'D', 'tb_ct', array['id_emp','id_ct'], array['1', cast(_item.id as varchar)], CURRENT_TIMESTAMP, nextval('sq_sinc'));
                 
            fetch _list into _item;
        end loop;
    end if;

end;
$$;

--
-- tb_cte
--
do $$
declare
    _item record;
    _list refcursor;
begin
    if (coalesce(fc_get_emp_cnf(1, 27005), '') <> '') then
        open _list for 
            select
                tb.id
            from
            (
                select generate_series(min(id_cte), max(id_cte)) as id
                from tb_cte

            ) as tb
            where
                not exists 
                (
                    select 1
                    from tb_cte
                    where
                        tb.id = tb_cte.id_cte
                )
                
            order by id;
           
        fetch _list into _item;
        
        while found loop
            
            insert into tb_sinc
                (id_est, op, tb, col_pk, val_pk, dt_hr, id_sinc)
            values
                (1, 'D', 'tb_cte', array['id_emp','id_cte'], array['1', cast(_item.id as varchar)], CURRENT_TIMESTAMP, nextval('sq_sinc'));
                 
            fetch _list into _item;
        end loop;
    end if;
    
end;
$$;

--
-- tb_contr_frete
--
do $$
declare
    _item record;
    _list refcursor;
begin
    if (coalesce(fc_get_emp_cnf(1, 27005), '') <> '') then
        open _list for 
            select
                tb.id
            from
            (
                select generate_series(min(id_contr_frete), max(id_contr_frete)) as id
                from tb_contr_frete

            ) as tb
            where
                not exists 
                (
                    select 1
                    from tb_contr_frete
                    where
                        tb.id = tb_contr_frete.id_contr_frete
                )
                
            order by id;
           
        fetch _list into _item;
        
        while found loop
            
            insert into tb_sinc
                (id_est, op, tb, col_pk, val_pk, dt_hr, id_sinc)
            values
                (1, 'D', 'tb_contr_frete', array['id_emp','id_contr_frete'], array['1', cast(_item.id as varchar)], CURRENT_TIMESTAMP, nextval('sq_sinc'));
                 
            fetch _list into _item;
        end loop;
    end if;
end;
$$;

--
-- tb_vnd
--
do $$
declare
    _item record;
    _list refcursor;
begin
    if (coalesce(fc_get_emp_cnf(1, 27005), '') <> '') then
        open _list for 
            select
                tb.id
            from
            (
                select generate_series(min(id_vnd), max(id_vnd)) as id
                from tb_vnd

            ) as tb
            where
                not exists 
                (
                    select 1
                    from tb_vnd
                    where
                        tb.id = tb_vnd.id_vnd
                )
                
            order by id;
           
        fetch _list into _item;
        
        while found loop
            
            insert into tb_sinc
                (id_est, op, tb, col_pk, val_pk, dt_hr, id_sinc)
            values
                (1, 'D', 'tb_vnd', array['id_emp','id_vnd'], array['1', cast(_item.id as varchar)], CURRENT_TIMESTAMP, nextval('sq_sinc'));
                 
            fetch _list into _item;
        end loop;
    end if;
end;
$$;

--
-- tb_msg
--
do $$
declare
    _item record;
    _list refcursor;
begin
    if (coalesce(fc_get_emp_cnf(1, 27005), '') <> '') then
        open _list for 
            select
                tb.id
            from
            (
                select generate_series(min(id_msg), max(id_msg)) as id
                from tb_msg

            ) as tb
            where
                not exists 
                (
                    select 1
                    from tb_msg
                    where
                        tb.id = tb_msg.id_msg
                )
                
            order by id;
           
        fetch _list into _item;
        
        while found loop
            
            insert into tb_sinc
                (id_est, op, tb, col_pk, val_pk, dt_hr, id_sinc)
            values
                (1, 'D', 'tb_msg', array['id_msg'], array[cast(_item.id as varchar)], CURRENT_TIMESTAMP, nextval('sq_sinc'));
                 
            fetch _list into _item;
        end loop;
    end if;
    
end;
$$;