CREATE OR REPLACE VIEW public.vw_item_pt_prc(
    id,
    id_emp,
    id_item,
    id_pt_prc,
    id_und_med_item,
    id_und_med,
    vl_prc_vnd,
    cd_bar,
    vl_conv)
AS
  SELECT (((((tb.id_emp || '.'::text) || tb.id_item) || '.'::text) ||
    tb.id_pt_prc) || '.'::text) || tb.id_und_med::text AS id,
         tb.id_emp,
         tb.id_item,
         tb.id_pt_prc,
         tb.id_und_med_item,
         tb.id_und_med,
         tb.vl_prc_vnd,
         tb.cd_bar,
         tb.vl_conv
  FROM (((
           SELECT tb_item_emp.id_emp,
                  tb_item.id_item,
                  0 AS id_pt_prc,
                  tb_item.id_und_med AS id_und_med_item,
                  tb_item.id_und_med,
                  tb_item_emp.vl_prc_vnd,
                  tb_item.cd_bar,
                  1 AS vl_conv
           FROM tb_item
                LEFT JOIN tb_item_emp ON tb_item.id_item = tb_item_emp.id_item
           UNION ALL
           SELECT tb_item_emp.id_emp,
                  tb_item.id_item,
                  0 AS id_pt_prc,
                  tb_item.id_und_med AS id_und_med_item,
                  tb_item_und_med.id_und_med,
                  CASE
                    WHEN COALESCE(tb_item_und_med.vl_prc_vnd, 0::numeric) <> 0::
                      numeric THEN tb_item_und_med.vl_prc_vnd
                    ELSE tb_item_emp.vl_prc_vnd * tb_item_und_med.vl_conv
                  END AS vl_prc_vnd,
                  tb_item_und_med.cd_bar,
                  tb_item_und_med.vl_conv
           FROM tb_item
                JOIN tb_item_und_med ON tb_item.id_item =
                  tb_item_und_med.id_item
                LEFT JOIN tb_item_emp ON tb_item.id_item = tb_item_emp.id_item
         )
         UNION ALL
         SELECT tb_item_emp.id_emp,
                tb_item.id_item,
                tb_pt_prc.id_pt_prc,
                tb_item.id_und_med AS id_und_med_item,
                tb_item.id_und_med,
                CASE
                  WHEN COALESCE(tb_item_pt_prc.vl_prc_vnd, 0::numeric) <> 0::
                    numeric THEN tb_item_pt_prc.vl_prc_vnd
                  ELSE tb_item_emp.vl_prc_vnd
                END AS vl_prc_vnd,
                tb_item.cd_bar,
                1 AS vl_conv
         FROM tb_item
              JOIN tb_pt_prc ON true
              LEFT JOIN tb_item_emp ON tb_item.id_item = tb_item_emp.id_item
              LEFT JOIN tb_item_pt_prc ON tb_item.id_item =
                tb_item_pt_prc.id_item AND (tb_item.id_und_med::text =
                tb_item_pt_prc.id_und_med::text OR tb_item_pt_prc.id_und_med::
                text = ''::text) AND tb_pt_prc.id_pt_prc =
                tb_item_pt_prc.id_pt_prc AND tb_item_pt_prc.id_emp =
                tb_item_emp.id_emp
        )
        UNION ALL
        SELECT tb_item_emp.id_emp,
               tb_item.id_item,
               tb_pt_prc.id_pt_prc,
               tb_item.id_und_med AS id_und_med_item,
               tb_item_und_med.id_und_med,
               CASE
                 WHEN COALESCE(tb_item_pt_prc.vl_prc_vnd, 0::numeric) <> 0::
                   numeric THEN tb_item_pt_prc.vl_prc_vnd
                 WHEN COALESCE(tb_item_und_med.vl_prc_vnd, 0::numeric) <> 0::
                   numeric THEN tb_item_und_med.vl_prc_vnd
                 ELSE tb_item_emp.vl_prc_vnd * COALESCE(tb_item_und_med.vl_conv,
                   1::numeric)
               END AS vl_prc_vnd,
               tb_item_und_med.cd_bar,
               COALESCE(tb_item_und_med.vl_conv, 1::numeric) AS vl_conv
        FROM tb_item
             JOIN tb_pt_prc ON true
             LEFT JOIN tb_item_emp ON tb_item.id_item = tb_item_emp.id_item
             JOIN tb_item_und_med ON tb_item.id_item = tb_item_und_med.id_item
             LEFT JOIN tb_item_pt_prc ON tb_item_und_med.id_item =
               tb_item_pt_prc.id_item AND tb_item_und_med.id_und_med::text =
               tb_item_pt_prc.id_und_med::text AND tb_pt_prc.id_pt_prc =
               tb_item_pt_prc.id_pt_prc AND tb_item_pt_prc.id_emp =
               tb_item_emp.id_emp
       ) tb
  ORDER BY tb.id_item,
           tb.id_emp, tb.id_pt_prc, tb.id_und_med;