SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_pt_prc_bf (
)
RETURNS trigger AS
$body$
declare
    _nf_item record;
    _item_pt_prc record;
begin
    select * into _nf_item
    from tb_nf_item
    where
        id_emp = new.id_emp and
        id_nf = new.id_nf and
        id_nf_item = new.id_nf_item;
        
    if (_nf_item.at_prc_item) then
        select * into _item_pt_prc
        from tb_item_pt_prc
        where
            id_emp = new.id_emp and
            id_item = _nf_item.id_item and
            id_pt_prc = new.id_pt_prc;
            
        if (found) then
            update tb_item_pt_prc set
                vl_prc_vnd = new.vl_prc_vnd
            where
                id_emp = new.id_emp and 
                id_item = _nf_item.id_item and
                id_pt_prc = new.id_pt_prc and
                id_und_med = '';
        else
            insert into tb_item_pt_prc
                (id_emp, id_item, id_pt_prc, id_und_med, vl_prc_vnd)
            values
                (new.id_emp, _nf_item.id_item, new.id_pt_prc, '', new.vl_prc_vnd);
        end if;
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

