SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_mdfe_bf (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
begin

    _app_con := fc_app_con();
    
    if (tg_op in ('INSERT', 'UPDATE') ) and (_app_con <> 'NEO_UNI') then
        if (tg_op  = 'INSERT' and new.num is null) then
            new.num := fc_get_num_mdfe(new.id_emp, new.ser);
        end if;
    end if;
    
    
    if (tg_op in ('INSERT', 'UPDATE') ) then
        return new;
    else
        return old;
    end if;

end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_cte_bf (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
begin

    _app_con := fc_app_con();
    
    if (tg_op in ('INSERT', 'UPDATE') ) and (_app_con <> 'NEO_UNI') then
        if (tg_op  = 'INSERT' and new.num is null) then
            new.num := fc_get_num_cte(new.id_emp, new.ser);
        end if;
    end if;
    
    
    if (tg_op in ('INSERT', 'UPDATE') ) then
        return new;
    else
        return old;
    end if;

end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TRIGGER tr_cte_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_cte FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_cte_bf();

-- !!! The object has a circular dependency. Script correction required

CREATE TRIGGER tr_mdfe_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_mdfe FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_mdfe_bf();

