CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
begin
    _app_con := fc_app_con();

    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
        
   end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select 
                tb_nf.tp_emis as tp_emis_nf,
                tb_nat_op.* 
            into 
                _nat_op
            from tb_nf
            join tb_nat_op on
                (tb_nf.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_nf.id_emp = new.id_emp and
                tb_nf.id_nf = new.id_nf;
                
            _gera_fin :=
                (_nat_op.tp_emis_nf = '[P]' and _nat_op.op like '%[NF_EMT__GER_FIN]%') or
                (_nat_op.tp_emis_nf = '[T]' and _nat_op.op like '%[NF_REC__GER_FIN]%');
                
                
            if (_op_fnc.gera_ct and _gera_fin) then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, 
                     id_cnt_bnc, org,
                     obs, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, _nf.id_part_emt, new.nr_doc, new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     new.id_cnt_bnc, 'NF.' || new.id_nf || '.' || new.id_nf_parc,
                     'NF ' || _nf.num || ' ' || _op_fnc.descr, new.id_op_fnc, 0, new.vl_parc, 
                     new.id_plano_ct,
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_plano_ct)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _nf.dt_op, new.dt_venc, new.nr_doc, 'D', new.vl_parc, 'NF ' || _nf.num || ' ' || _op_fnc.descr, false,
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, _nf.id_nf,
                     _nf.id_part_emt, 'PEND',
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     new.id_plano_ct);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;