CREATE SEQUENCE public.sq_rom_frete
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_rom_frete_parc_cli_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _rom_frete record;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'ROM_FRETE.CLI.' || old.id_rom_frete || '.' || old.id_rom_frete_parc_cli;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
    
        select * into _rom_frete
        from tb_rom_frete
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete;
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, id_op_fnc, vl_quit, vl_rest, 
             -- id_plano_ct,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _rom_frete.id_tom, new.id_rom_frete, new.id_rom_frete_parc_cli, new.qtd_parc,
             _rom_frete.dt_lanc, new.dt_venc, new.vl_parc, 'P', 
             'ROM_FRETE.CLI.' || new.id_rom_frete || '.' || new.id_rom_frete_parc_cli, _op_fnc.id_op_fnc, 0, new.vl_parc, 
             -- new.id_plano_ct,
             new.vl_parc, 0, 0, 0, 0, 
             _rom_frete.id_usr_ult_alt, _rom_frete.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_rom_frete_item_parc_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _rom_frete_item record;
    _rom_frete record;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'ROM_FRETE.ITEM.' || old.id_rom_frete || '.' || old.id_rom_frete_item_parc;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = 'DUP'
        limit 1;
    
        select * into _rom_frete
        from tb_rom_frete
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete;
            
        select * into _rom_frete_item
        from tb_rom_frete_item
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete and
            id_rom_frete_item = new.id_rom_frete_item;
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, id_op_fnc, vl_quit, vl_rest, 
             -- id_plano_ct,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _rom_frete_item.id_colab, new.id_rom_frete, new.parc, new.qtd_parc,
             _rom_frete.dt_lanc, new.dt_venc, new.vl_parc, 'P', 
             'ROM_FRETE.ITEM.' || new.id_rom_frete || '.' || new.id_rom_frete_item_parc, _op_fnc.id_op_fnc, 0, new.vl_parc, 
             -- new.id_plano_ct,
             new.vl_parc, 0, 0, 0, 0, 
             _rom_frete.id_usr_ult_alt, _rom_frete.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_req_colab_parc_forn_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _req_colab record;
BEGIN
    select * into _op_fnc
    from tb_op_fnc
    where
        tp_op_fnc = 'DUP'
    limit 1;
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'REQ_COLAB.FORN.' || old.id_req_colab || '.' || old.id_req_colab_parc_forn;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _req_colab
        from tb_req_colab
        where
            id_emp = new.id_emp and
            id_req_colab = new.id_req_colab;
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, id_op_fnc, vl_quit, vl_rest, 
             -- id_plano_ct,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _req_colab.id_forn, new.id_req_colab, new.id_req_colab_parc_forn, new.qtd_parc,
             _req_colab.dt_req_colab, new.dt_venc, new.vl_parc, 'P', 
             'REQ_COLAB.FORN.' || new.id_req_colab || '.' || new.id_req_colab_parc_forn, _op_fnc.id_op_fnc, 0, new.vl_parc, 
             -- new.id_plano_ct,
             new.vl_parc, 0, 0, 0, 0, 
             _req_colab.id_usr_ult_alt, _req_colab.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_req_colab_parc_colab_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _req_colab record;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'REQ_COLAB.COLAB.' || old.id_req_colab || '.' || old.id_req_colab_parc_colab;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = 'DUP'
        limit 1;
    
        select * into _req_colab
        from tb_req_colab
        where
            id_emp = new.id_emp and
            id_req_colab = new.id_req_colab;
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, id_op_fnc, vl_quit, vl_rest, 
             -- id_plano_ct,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _req_colab.id_colab, new.id_req_colab, new.id_req_colab_parc_colab, new.qtd_parc,
             _req_colab.dt_req_colab, new.dt_venc, new.vl_parc, 'P', 
             'REQ_COLAB.COLAB.' || new.id_req_colab || '.' || new.id_req_colab_parc_colab, _op_fnc.id_op_fnc, 0, new.vl_parc, 
             -- new.id_plano_ct,
             new.vl_parc, 0, 0, 0, 0, 
             _req_colab.id_usr_ult_alt, _req_colab.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_rom_frete (
  id_emp INTEGER NOT NULL, 
  id_rom_frete INTEGER NOT NULL, 
  num INTEGER, 
  dt_lanc DATE, 
  dt_emb DATE, 
  hr_emb TIME WITHOUT TIME ZONE, 
  dist NUMERIC(12,2), 
  sit VARCHAR(2), 
  id_tom INTEGER, 
  id_org INTEGER, 
  id_ender_org INTEGER, 
  id_dest INTEGER, 
  id_ender_dest INTEGER, 
  vl_tot NUMERIC(12,4), 
  obs VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_rom_frete PRIMARY KEY(id_emp, id_rom_frete)
) ;

CREATE TABLE public.tb_rom_frete_parc_cli (
  id_emp INTEGER NOT NULL, 
  id_rom_frete INTEGER NOT NULL, 
  id_rom_frete_parc_cli INTEGER NOT NULL, 
  qtd_parc INTEGER, 
  id_op_fnc INTEGER, 
  dt_venc DATE, 
  vl_parc NUMERIC(12,4), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_rom_frete_parc_cli PRIMARY KEY(id_emp, id_rom_frete, id_rom_frete_parc_cli)
) ;

CREATE TRIGGER tr_rom_frete_parc_cli_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_rom_frete_parc_cli FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_rom_frete_parc_cli_bf();

CREATE TABLE public.tb_rom_frete_item (
  id_emp INTEGER NOT NULL, 
  id_rom_frete INTEGER NOT NULL, 
  id_rom_frete_item INTEGER NOT NULL, 
  id_item INTEGER, 
  vl_unt NUMERIC(12,4), 
  vl_dist NUMERIC(12,4), 
  vl_sub_tot NUMERIC(12,4), 
  vl_ded NUMERIC(12,4), 
  vl_tot NUMERIC(12,4), 
  id_veic INTEGER, 
  id_colab INTEGER, 
  vl_perc_comis NUMERIC(12,4), 
  vl_comis NUMERIC(12,4), 
  vl_pag NUMERIC(12,4), 
  obs VARCHAR(250), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_rom_frete_item PRIMARY KEY(id_emp, id_rom_frete, id_rom_frete_item)
) ;

CREATE TABLE public.tb_rom_frete_item_parc (
  id_emp INTEGER NOT NULL, 
  id_rom_frete INTEGER NOT NULL, 
  id_rom_frete_item INTEGER NOT NULL, 
  id_rom_frete_item_parc INTEGER NOT NULL, 
  dt_venc DATE, 
  vl_parc NUMERIC(12,4), 
  qtd_parc INTEGER, 
  parc INTEGER, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_rom_frete_item_parc PRIMARY KEY(id_emp, id_rom_frete, id_rom_frete_item, id_rom_frete_item_parc)
) ;

CREATE TRIGGER tr_rom_frete_item_parc_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_rom_frete_item_parc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_rom_frete_item_parc_bf();

CREATE TABLE public.tb_rom_frete_item_ded (
  id_emp INTEGER NOT NULL, 
  id_rom_frete INTEGER NOT NULL, 
  id_rom_frete_item INTEGER NOT NULL, 
  id_rom_frete_item_ded INTEGER NOT NULL, 
  descr VARCHAR(150), 
  vl_ded NUMERIC(12,4), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_rom_frete_item_ded PRIMARY KEY(id_emp, id_rom_frete, id_rom_frete_item, id_rom_frete_item_ded)
) ;

ALTER TABLE public.tb_rom_frete_parc_cli
  ADD CONSTRAINT fk__rom_frete_parc_cli__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_parc_cli
  ADD CONSTRAINT fk__rom_frete_parc_cli__rom_frete FOREIGN KEY (id_emp, id_rom_frete)
    REFERENCES public.tb_rom_frete(id_emp, id_rom_frete)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_item_parc
  ADD CONSTRAINT fk__rom_frete_item_parc__rom_frete_item FOREIGN KEY (id_emp, id_rom_frete, id_rom_frete_item)
    REFERENCES public.tb_rom_frete_item(id_emp, id_rom_frete, id_rom_frete_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_item_ded
  ADD CONSTRAINT fk__rom_frete_item_ded__rom_frete_item FOREIGN KEY (id_emp, id_rom_frete, id_rom_frete_item)
    REFERENCES public.tb_rom_frete_item(id_emp, id_rom_frete, id_rom_frete_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_item
  ADD CONSTRAINT fk__rom_frete_item__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_item
  ADD CONSTRAINT fk__rom_frete_item__mot FOREIGN KEY (id_colab)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_item
  ADD CONSTRAINT fk__rom_frete_item__rom_frete FOREIGN KEY (id_emp, id_rom_frete)
    REFERENCES public.tb_rom_frete(id_emp, id_rom_frete)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete_item
  ADD CONSTRAINT fk__rom_frete_item__veic FOREIGN KEY (id_veic)
    REFERENCES public.tb_veic(id_veic)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete
  ADD CONSTRAINT fk__rom_frete__dest FOREIGN KEY (id_dest)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete
  ADD CONSTRAINT fk__rom_frete__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete
  ADD CONSTRAINT fk__rom_frete__rem FOREIGN KEY (id_org)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_frete
  ADD CONSTRAINT fk__rom_frete__tom FOREIGN KEY (id_tom)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

