SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
    
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    
    _op_fnc record;    
    
    _app_con varchar;
    _nr_doc integer;
    
    _vl_quit numeric;
    _vl_rest numeric;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        select sum(tb_bx_ct__ct.vl_quit), min(tb_bx_ct__ct.vl_rest) into _vl_quit, _vl_rest
        from tb_bx_ct__ct
        where
            tb_bx_ct__ct.id_emp_ct = new.id_emp and
            tb_bx_ct__ct.id_ct = new.id_ct;
            
        

    
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and (new.tp_doc = 'CH' or new.tp_doc = 'CH_PRZ')) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, new.id_ct, new.id_part);
        end if;
        
        --
        -- Gera proxima ct contrato
        --
        if (tg_op = 'UPDATE') then
        
            if (new.tp_ct = 'R' and new.stat = 'Q' and old.stat = 'P' and new.org like 'CONTR.%') then
                _aux := regexp_split_to_array(new.org, '\.');
                
                select count(*) into _qtd
                from tb_ct
                where
                    id_emp = new.id_emp and
                    id_part = new.id_part and
                    tp_ct = 'R' and
                    org = new.org and
                    dt_venc > new.dt_venc and
                    id_ct <> new.id_ct;
                
                if (_qtd = 0) then
                    
                    select 
                        tb_part_contr.*,
                        tb_op_fnc.tp_op_fnc
                    into _contr
                    from tb_part_contr
                    join tb_op_fnc on
                        (tb_part_contr.id_op_fnc = tb_op_fnc.id_op_fnc)
                    where
                        id_emp = new.id_emp and
                        id_part = new.id_part and
                        id_part_contr = cast(_aux[3] as integer);
                
                    if (found) then
                    
                        _dt_venc := fc_calc_venc(new.dt_venc, _contr.tp_interv, _contr.interv);
                        
                        if (_dt_venc <= _contr.dt_f) then
                            _id_cnt_bnc := null;
        
                            if (_contr.tp_op_fnc = 'BLT') then
                                _id_cnt_bnc_str := fc_get_emp_cnf(new.id_emp, 01002);
                                
                                if (_id_cnt_bnc_str <> '') then
                                    _id_cnt_bnc := cast(_id_cnt_bnc_str as integer);
                                end if;
                            end if;
                            
                            insert into tb_ct
                                (id_emp, id_ct, tp_ct, id_part, parc, qtd_parc, dt_emis, dt_venc,
                                 vl_ct, obs, stat, tp_doc, org, id_cnt_bnc, id_op_fnc, vl_quit, vl_rest, id_plano_ct,
                                 nr_doc)
                            values
                                (_contr.id_emp, nextval('sq_ct'), 'R', _contr.id_part, new.parc + 1, new.parc + 1, new.dt_venc, _dt_venc,
                                 _contr.vl_contr, _contr.obs, 'P', _contr.tp_doc, new.org, _id_cnt_bnc, _contr.id_op_fnc, 0, _contr.vl_contr, _contr.id_plano_ct,
                                 cast(_nr_doc as varchar));
                        end if;
                    end if;
                end if;
            elsif (new.tp_ct = 'R' and new.stat = 'P' and old.stat = 'Q' and new.org like 'CONTR.%') then
                _aux := regexp_split_to_array(new.org, '\.');
                    
                select * into _contr
                from tb_part_contr
                where
                    id_emp = new.id_emp and
                    id_part = new.id_part and
                    id_part_contr = cast(_aux[3] as integer);
                        
                if (found) then
                    _dt_venc := fc_calc_venc(new.dt_venc, _contr.tp_interv, _contr.interv);
                    
                    delete from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_part = new.id_part and
                        tp_ct = 'R' and
                        org = new.org and
                        dt_venc = _dt_venc and
                        stat = 'P' and
                        id_ct <> new.id_ct;
                end if;
            end if;
        end if;
        
        -- return new;
    elsif (tg_op = 'DELETE') then
        if (old.tp_ct = 'P') and (_app_con <> 'NEO_UNI') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
                
            if (coalesce(old.org, '') like 'BX_MOV_FUNC.%') then
                _aux := regexp_split_to_array(old.org, '\.');
                
                update tb_mov_func set
                    id_bx_mov_func = null,
                    sit = 'P'
                where
                    id_emp = old.id_emp and
                    id_bx_mov_func = cast(_aux[2] as integer);
            end if;
                
        end if;
    end if;
    
    --
    -- Sef for boleto gera o numero do boleto
    --
    if ( (tg_op = 'INSERT' or (tg_op = 'UPDATE' and coalesce(new.nr_doc, '') = '') ) 
        and _app_con <> 'NEO_UNI') then
        
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'BLT') and (new.tp_ct = 'R') then
            _nr_doc := fc_num_blt(new.id_emp, new.id_op_fnc, new.id_cnt_bnc);
            
            new.nr_doc := cast(_nr_doc as varchar);
        end if;
    end if;
    
    if ((tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con = 'NEO_UNI')) then
        new.vl_quit := _vl_quit;
        new.vl_rest := _vl_rest;
        
        if (_vl_rest <= 0) then
            new.stat := 'Q';
        end if;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_nf
  ADD COLUMN dt_hr_aut TIMESTAMP(0) WITHOUT TIME ZONE;
