ALTER TABLE public.tb_vnd
  ADD COLUMN canc BOOLEAN;

ALTER TABLE public.tb_vnd
  ALTER COLUMN canc SET DEFAULT false;

ALTER TABLE public.tb_vnd
  ADD COLUMN id_mov_cx INTEGER;

-- update tb_vnd set canc = false;


SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _id_cli_cons varchar;
    
    _list refcursor;
    _item record;
    
begin
    _app_con := fc_app_con();

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
    
        if (new.org = 'CONSIG') then
            update tb_consig set
                sit = 'F'
            where
                id_emp = new.id_emp and
                id_consig = new.id_org;
        end if;
        
        _id_cli_cons := fc_get_emp_cnf(new.id_emp, 01000);
        
        if (cast(new.id_cli as varchar) <> _id_cli_cons) then
            
            update tb_part set
                id_cond_pagto = new.id_cond_pagto,
                id_fm_pagto = new.id_fm_pagto
            where
                id_part = new.id_cli;
                
        end if;
        
        if (new.id_sit_vnd is not null and new.cd_ref is not null) then
            perform fc_vnd_ident_sit(new.id_emp, cast(new.cd_ref as integer), new.id_sit_vnd);
        end if;
        
        
        --
        -- Venda cancelada
        --
        if (tg_op = 'UPDATE' and new.canc = true and new.canc <> old.canc) then
            --
            -- extorna o estoque
            --
            open _list for
                select *
                from tb_vnd_item
                where
                    id_emp = new.id_emp and
                    id_vnd = new.id_vnd and
                    mov_estq;

            fetch _list into _item;
                
            
            while found loop
                
                perform fc_item_estq(_item.id_item, _item.id_emp, _item.id_dep, _item.id_grd_estq, 'E', _item.vl_qtd_mov);
                
                fetch _list into _item;
                
            end loop;
            
            close _list;
            
            --
            -- extorna contas a receber
            --
            open _list for 
                select *
                from tb_vnd_parc
                where
                    id_emp = new.id_emp and
                    id_vnd = new.id_vnd;
                    
            fetch _list into _item;
            
            while found loop
                
                delete from tb_ct
                where 
                    id_emp = new.id_emp and
                    org = 'VND.' || new.id_vnd || '.' || _item.id_vnd_parc;
                
                delete from tb_mov_bnc
                where 
                    id_emp = new.id_emp and
                    org = 'VND.' || new.id_vnd || '.' || _item.id_vnd_parc;
                
                fetch _list into _item;
                
            end loop;
            
            
            
        end if;
            
            
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        if (old.org = 'CONSIG') then
            update tb_consig set
                sit = 'D'
            where
                id_emp = old.id_emp and
                id_consig = old.id_org;
        end if;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org like 'VND.' || old.id_vnd || '%';
    
    end if;
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_gera_mov_fnc (
  _tb_org varchar,
  _id_emp integer,
  _id_org integer,
  _id_mov_cx integer
)
RETURNS boolean AS
$body$
declare
    _org_list refcursor;
    _org record;
    _seq integer;
begin

    if (_tb_org = 'tb_vnd') then
        /*delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'VND.' || _id_org || '%';*/
    
        open _org_list for
            select
                tb_vnd.id_cx as id_cx,
                tb_vnd.id_usr as id_usr,
                tb_vnd.id_vnd as id_org,
                tb_vnd.dt_vnd as dt_lanc,
                cast(case when tb_vnd.canc then 'CANC VENDA: ' else 'VENDA: ' end || coalesce(tb_vnd.nome, '') as varchar) as descr,
                cast(case when tb_vnd.canc then 'D' else 'C' end as varchar) as op,
                sum(tb_vnd_parc.vl_parc) as vl_lanc,
                cast('VND.' || tb_vnd.id_vnd || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_vnd.id_vnd as varchar) as doc,
                tb_vnd.dt_hr_cad,
                tb_vnd.dt_hr_ult_alt,
                tb_vnd.id_est_cad,
                tb_vnd.id_est_ult_alt,
                tb_vnd.id_usr_cad, 
                tb_vnd.id_usr_ult_alt
            from tb_vnd
            join tb_vnd_parc on
                (tb_vnd.id_emp = tb_vnd_parc.id_emp and
                 tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
            join tb_op_fnc on
                (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_vnd.id_emp = _id_emp and
                tb_vnd.id_vnd = _id_org
            group by
                tb_vnd.id_cx,
                tb_vnd.id_vnd,
                tb_vnd.id_usr,
                tb_vnd.dt_vnd,
                tb_vnd.nome,
                tb_vnd.canc,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_vnd.dt_hr_cad,
                tb_vnd.dt_hr_ult_alt,
                tb_vnd.id_est_cad,
                tb_vnd.id_est_ult_alt,
                tb_vnd.id_usr_cad, 
                tb_vnd.id_usr_ult_alt;
                
    elsif (_tb_org = 'tb_bx_ct') then
    
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'BX.' || _id_org || '%';
    
        open _org_list for
            select
                tb_bx_ct.id_cx as id_cx,
                tb_bx_ct.id_usr as id_usr,
                tb_bx_ct.id_bx_ct as id_org,
                tb_bx_ct.dt_bx as dt_lanc,
                cast(
                    case 
                        when (coalesce(tb_bx_ct.op = 'R')) then 'RENEG: ' || coalesce(tb_part.nome, '')
                        when (tb_bx_ct.tp_bx = 'R') then 'REC: ' || coalesce(tb_part.nome, '')
                        when (tb_bx_ct.tp_bx = 'P') then 'PAG: ' || coalesce(tb_part.nome, '') 
                    end
                as varchar) as descr,
                cast(ifthen(tb_bx_ct.tp_bx = 'R', 'C', 'D') as varchar) as op,
                sum(tb_bx_ct_pagto.vl_pagto) as vl_lanc,
                cast('BX.' || tb_bx_ct.id_bx_ct || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_bx_ct.id_bx_ct as varchar) as doc,
                tb_bx_ct.dt_hr_cad,
                tb_bx_ct.dt_hr_ult_alt,
                tb_bx_ct.id_est_cad,
                tb_bx_ct.id_est_ult_alt,
                tb_bx_ct.id_usr_cad, 
                tb_bx_ct.id_usr_ult_alt
            from tb_bx_ct
            join tb_bx_ct_pagto on
                (tb_bx_ct.id_emp = tb_bx_ct_pagto.id_emp and
                 tb_bx_ct.id_bx_ct = tb_bx_ct_pagto.id_bx_ct)
            left outer join tb_part on
                (tb_bx_ct.id_part = tb_part.id_part)
            join tb_op_fnc on
                (tb_bx_ct_pagto.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_bx_ct.id_emp = _id_emp and
                tb_bx_ct.id_bx_ct = _id_org
            group by
                tb_bx_ct.id_cx,
                tb_bx_ct.id_bx_ct,
                tb_bx_ct.tp_bx,
                tb_bx_ct.id_usr,
                tb_bx_ct.dt_bx,
                tb_part.nome,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_bx_ct.op,
                tb_bx_ct.dt_hr_cad,
                tb_bx_ct.dt_hr_ult_alt,
                tb_bx_ct.id_est_cad,
                tb_bx_ct.id_est_ult_alt,
                tb_bx_ct.id_usr_cad, 
                tb_bx_ct.id_usr_ult_alt;
    
    elsif (_tb_org = 'tb_nf') then
    
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'NF.' || _id_org || '%';
    
        open _org_list for
            select
                tb_nf.id_cx as id_cx,
                tb_nf.id_usr as id_usr,
                tb_nf.id_nf as id_org,
                tb_nf.dt_op as dt_lanc,
                cast('NF: ' || coalesce(tb_nf.fant_emt, '') as varchar) as descr,
                cast('D' as varchar) as op,
                sum(tb_nf_parc.vl_parc) as vl_lanc,
                cast('NF.' || tb_nf.id_nf || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_nf.num as varchar) as doc,
                tb_nf.dt_hr_cad,
                tb_nf.dt_hr_ult_alt,
                tb_nf.id_est_cad,
                tb_nf.id_est_ult_alt,
                tb_nf.id_usr_cad, 
                tb_nf.id_usr_ult_alt
            from tb_nf
            join tb_nf_parc on
                (tb_nf.id_emp = tb_nf_parc.id_emp and
                 tb_nf.id_nf = tb_nf_parc.id_nf)
            join tb_op_fnc on
                (tb_nf_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true) and
                 tb_op_fnc.tp_op_fnc = 'DIN')
            where
                tb_nf.id_emp = _id_emp and
                tb_nf.id_nf = _id_org and
                tb_nf.tp_emis = '[T]'
            group by
                tb_nf.id_cx,
                tb_nf.id_nf,
                tb_nf.id_usr,
                tb_nf.dt_op,
                tb_nf.num,
                tb_nf.fant_emt,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_nf.dt_hr_cad,
                tb_nf.dt_hr_ult_alt,
                tb_nf.id_est_cad,
                tb_nf.id_est_ult_alt,
                tb_nf.id_usr_cad, 
                tb_nf.id_usr_ult_alt;
    
    end if;

    


    fetch _org_list into _org;
    
    while found loop

        _seq := fc_get_seq_mov_fnc(_id_emp, _org.id_cx);
    
        insert into tb_mov_fnc
            (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc,
             descr, op, vl_lanc, org, id_org, id_op_fnc, doc,
             dt_hr_cad, dt_hr_ult_alt, id_usr_cad, id_usr_ult_alt, id_est_cad, id_est_ult_alt, 
             seq, id_mov_cx)
        values
            (_id_emp, nextval('sq_mov_fnc'), _org.id_cx, _org.id_usr, _org.dt_lanc, substring(cast(current_time as varchar), 1, 8)::time, 
             _org.descr, _org.op, _org.vl_lanc, _org.org, _org.id_org, _org.id_op_fnc, _org.doc,
             _org.dt_hr_cad, CURRENT_TIMESTAMP, _org.id_usr_cad, _org.id_usr_ult_alt, _org.id_est_cad, _org.id_est_ult_alt, 
             _seq, _id_mov_cx);
    
        fetch _org_list into _org;
        
    end loop;
    
    close _org_list;


    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

