CREATE SEQUENCE public.sq_req
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE TABLE public.tb_req (
  id_emp INTEGER NOT NULL, 
  id_req INTEGER NOT NULL, 
  id_forn INTEGER, 
  vl_tot NUMERIC(12,4), 
  req VARCHAR(150), 
  emit VARCHAR(150), 
  final VARCHAR(255), 
  obs VARCHAR(255), 
  dt_req DATE, 
  CONSTRAINT pk_req PRIMARY KEY(id_emp, id_req)
) ;

CREATE TABLE public.tb_req_item (
  id_emp INTEGER NOT NULL, 
  id_req INTEGER NOT NULL, 
  id_req_item INTEGER NOT NULL, 
  descr VARCHAR(150), 
  id_und_med VARCHAR(5), 
  vl_qtd NUMERIC(12,4), 
  CONSTRAINT pk_req_item PRIMARY KEY(id_emp, id_req, id_req_item)
) ;

ALTER TABLE public.tb_req_item
  ADD CONSTRAINT fk__req_item__req FOREIGN KEY (id_emp, id_req)
    REFERENCES public.tb_req(id_emp, id_req)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_req_item
  ADD CONSTRAINT fk__req_item__und_med FOREIGN KEY (id_und_med)
    REFERENCES public.tb_und_med(id_und_med)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_req
  ADD CONSTRAINT fk__req__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_req
  ADD CONSTRAINT fk__req__forn FOREIGN KEY (id_forn)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

