CREATE OR REPLACE VIEW public.vw_vnd_rota(
    id_emp,
    dt_vnd,
    dia_semana,
    id_rota,
    id_vndr,
    descr,
    vl_cred,
    vl_ch_prz,
    vl_ch_vst,
    vl_blt,
    vl_out,
    qtd_cli)
AS
  select tb.id_emp,
         tb.dt_vnd,
         tb.dia_semana,
         tb.id_rota,
         tb.id_vndr,
         tb.descr,
         sum(tb.vl_cred) as vl_cred,
         sum(tb.vl_ch_prz) as vl_ch_prz,
         sum(tb.vl_ch_vst) as vl_ch_vst,
         sum(tb.vl_blt) as vl_blt,
         sum(tb.vl_out) as vl_out,
         sum(tb.qtd_cli) as qtd_cli
  from (((((
             select tb_vnd.id_emp,
                    tb_vnd.dt_vnd,
                    case date_part('dow', tb_vnd.dt_vnd)
                      when 0 then 'Domingo'
                      when 1 then 'Segunda'
                      when 2 then 'Tera'
                      when 3 then 'Quarta'
                      when 4 then 'Quinta'
                      when 5 then 'Sexta'
                      when 6 then 'Sabado'
                      else null
                    end as dia_semana,
                    tb_part.id_rota,
                    tb_vnd.id_vndr,
                    tb_rota.descr,
                    0 as vl_cred,
                    0 as vl_ch_prz,
                    0 as vl_ch_vst,
                    0 as vl_blt,
                    0 as vl_out,
                    count(*) as qtd_cli
             from tb_vnd
                  left join tb_part on tb_vnd.id_cli = tb_part.id_part
                  left join tb_rota on tb_part.id_rota = tb_rota.id_rota
             group by tb_vnd.id_emp,
                      tb_vnd.dt_vnd,
                      tb_part.id_rota,
                      tb_vnd.id_vndr,
                      tb_rota.descr
             union all
             select tb_vnd.id_emp,
                    tb_vnd.dt_vnd,
                    case date_part('dow', tb_vnd.dt_vnd)
                      when 0 then 'Domingo'
                      when 1 then 'Segunda'
                      when 2 then 'Tera'
                      when 3 then 'Quarta'
                      when 4 then 'Quinta'
                      when 5 then 'Sexta'
                      when 6 then 'Sabado'
                      else null
                    end as dia_semana,
                    tb_part.id_rota,
                    tb_vnd.id_vndr,
                    tb_rota.descr,
                    sum(tb_vnd_parc.vl_parc) as vl_cred,
                    0 as vl_ch_prz,
                    0 as vl_ch_vst,
                    0 as vl_blt,
                    0 as vl_out,
                    0 as qtd_cli
             from tb_vnd
                  left join tb_part on tb_vnd.id_cli = tb_part.id_part
                  left join tb_rota on tb_part.id_rota = tb_rota.id_rota
                  left join tb_vnd_parc on tb_vnd.id_emp = tb_vnd_parc.id_emp
                      and tb_vnd.id_vnd = tb_vnd_parc.id_vnd
                  join tb_op_fnc on tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
             where tb_vnd.id_emp = tb_vnd_parc.id_emp and
                   tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
                   tb_op_fnc.tp_op_fnc = 'DUP'
             group by tb_vnd.id_emp,
                      tb_vnd.dt_vnd,
                      tb_part.id_rota,
                      tb_vnd.id_vndr,
                      tb_rota.descr
           )
           union all
           select tb_vnd.id_emp,
                  tb_vnd.dt_vnd,
                  case date_part('dow', tb_vnd.dt_vnd)
                    when 0 then 'Domingo'
                    when 1 then 'Segunda'
                    when 2 then 'Tera'
                    when 3 then 'Quarta'
                    when 4 then 'Quinta'
                    when 5 then 'Sexta'
                    when 6 then 'Sabado'
                    else null
                  end as dia_semana,
                  tb_part.id_rota,
                  tb_vnd.id_vndr,
                  tb_rota.descr,
                  0 as vl_cred,
                  sum(tb_vnd_parc.vl_parc) as vl_ch_prz,
                  0 as vl_ch_vst,
                  0 as vl_blt,
                  0 as vl_out,
                  0 as qtd_cli
           from tb_vnd
                left join tb_part on tb_vnd.id_cli = tb_part.id_part
                left join tb_rota on tb_part.id_rota = tb_rota.id_rota
                left join tb_vnd_parc on tb_vnd.id_emp = tb_vnd_parc.id_emp and
                    tb_vnd.id_vnd = tb_vnd_parc.id_vnd
                join tb_op_fnc on tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
           where tb_vnd.id_emp = tb_vnd_parc.id_emp and
                 tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
                 tb_op_fnc.tp_op_fnc = 'CH_PRZ'
           group by tb_vnd.id_emp,
                    tb_vnd.dt_vnd,
                    tb_part.id_rota,
                    tb_vnd.id_vndr,
                    tb_rota.descr
          )
          union all
          select tb_vnd.id_emp,
                 tb_vnd.dt_vnd,
                 case date_part('dow', tb_vnd.dt_vnd)
                   when 0 then 'Domingo'
                   when 1 then 'Segunda'
                   when 2 then 'Tera'
                   when 3 then 'Quarta'
                   when 4 then 'Quinta'
                   when 5 then 'Sexta'
                   when 6 then 'Sabado'
                   else null
                 end as dia_semana,
                 tb_part.id_rota,
                 tb_vnd.id_vndr,
                 tb_rota.descr,
                 0 as vl_cred,
                 0 as vl_ch_prz,
                 sum(tb_vnd_parc.vl_parc) as vl_ch_vst,
                 0 as vl_blt,
                 0 as vl_out,
                 0 as qtd_cli
          from tb_vnd
               left join tb_part on tb_vnd.id_cli = tb_part.id_part
               left join tb_rota on tb_part.id_rota = tb_rota.id_rota
               left join tb_vnd_parc on tb_vnd.id_emp = tb_vnd_parc.id_emp and
                   tb_vnd.id_vnd = tb_vnd_parc.id_vnd
               join tb_op_fnc on tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
          where tb_vnd.id_emp = tb_vnd_parc.id_emp and
                tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
                tb_op_fnc.tp_op_fnc = 'CH'
          group by tb_vnd.id_emp,
                   tb_vnd.dt_vnd,
                   tb_part.id_rota,
                   tb_vnd.id_vndr,
                   tb_rota.descr
         )
         union all
         select tb_vnd.id_emp,
                tb_vnd.dt_vnd,
                case date_part('dow', tb_vnd.dt_vnd)
                  when 0 then 'Domingo'
                  when 1 then 'Segunda'
                  when 2 then 'Tera'
                  when 3 then 'Quarta'
                  when 4 then 'Quinta'
                  when 5 then 'Sexta'
                  when 6 then 'Sabado'
                  else null
                end as dia_semana,
                tb_part.id_rota,
                tb_vnd.id_vndr,
                tb_rota.descr,
                0 as vl_cred,
                0 as vl_ch_prz,
                0 as vl_ch_vst,
                sum(tb_vnd_parc.vl_parc) as vl_blt,
                0 as vl_out,
                0 as qtd_cli
         from tb_vnd
              left join tb_part on tb_vnd.id_cli = tb_part.id_part
              left join tb_rota on tb_part.id_rota = tb_rota.id_rota
              left join tb_vnd_parc on tb_vnd.id_emp = tb_vnd_parc.id_emp and
                  tb_vnd.id_vnd = tb_vnd_parc.id_vnd
              join tb_op_fnc on tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
         where tb_vnd.id_emp = tb_vnd_parc.id_emp and
               tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
               tb_op_fnc.tp_op_fnc = 'BLT'
         group by tb_vnd.id_emp,
                  tb_vnd.dt_vnd,
                  tb_part.id_rota,
                  tb_vnd.id_vndr,
                  tb_rota.descr
        )
        union all
        select tb_vnd.id_emp,
               tb_vnd.dt_vnd,
               case date_part('dow', tb_vnd.dt_vnd)
                 when 0 then 'Domingo'
                 when 1 then 'Segunda'
                 when 2 then 'Tera'
                 when 3 then 'Quarta'
                 when 4 then 'Quinta'
                 when 5 then 'Sexta'
                 when 6 then 'Sabado'
                 else null
               end as dia_semana,
               tb_part.id_rota,
               tb_vnd.id_vndr,
               tb_rota.descr,
               0 as vl_cred,
               0 as vl_ch_prz,
               0 as vl_ch_vst,
               0 as vl_blt,
               sum(tb_vnd_parc.vl_parc) as vl_out,
               0 as qtd_cli
        from tb_vnd
             left join tb_part on tb_vnd.id_cli = tb_part.id_part
             left join tb_rota on tb_part.id_rota = tb_rota.id_rota
             left join tb_vnd_parc on tb_vnd.id_emp = tb_vnd_parc.id_emp and
                 tb_vnd.id_vnd = tb_vnd_parc.id_vnd
             join tb_op_fnc on tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
        where tb_vnd.id_emp = tb_vnd_parc.id_emp and
              tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
              (tb_op_fnc.tp_op_fnc <> all (array [ 'DUP', 'CH', 'CH', 'BLT', 'CH_PRZ' ]))
        group by tb_vnd.id_emp,
                 tb_vnd.dt_vnd,
                 tb_part.id_rota,
                 tb_vnd.id_vndr,
                 tb_rota.descr
       ) tb
  group by tb.id_emp,
           tb.dt_vnd,
           tb.id_vndr,
           tb.dia_semana,
           tb.id_rota,
           tb.descr
  order by tb.dt_vnd;