CREATE OR REPLACE FUNCTION public.fc_tr_mnt_estq_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _app_con varchar;
    _op varchar;
    _upd_op varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
            if (lower(old.op) <> 'i') then
                _upd_op := ifthen(lower(old.op) = 'e', 's', 'e');
                
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep_dst, old.id_grd_estq, _upd_op, old.vl_qtd_mov);
                
                if (old.id_dep_org is not null) then
                    perform fc_item_estq(old.id_item, old.id_emp, old.id_dep_org, old.id_grd_estq, old.op, old.vl_qtd_mov);
                end if;
            end if;
        end if;
        
        
        if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
            if (lower(new.op) <> 'i') then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep_dst, new.id_grd_estq, new.op, new.vl_qtd_mov);
                    
                if (new.id_dep_org is not null) then
                    perform fc_item_estq(new.id_item, new.id_emp, new.id_dep_org, new.id_grd_estq, 's', new.vl_qtd_mov);
                end if;
            end if;
            
            if (lower(new.op) = 'e') then
                if not exists(select 1 
                              from tb_item_cd_bar 
                              where
                                  id_item = new.id_item and
                                  id_grd_estq = new.id_grd_estq)  and
                    exists (select 1
                            from tb_grd_estq
                            where
                                id_grd_estq = new.id_grd_estq and
                                gera_cd_bar) then
                    insert into tb_item_cd_bar
                        (id_item, cd_bar, id_grd_estq)
                    values
                        (new.id_item, new.id_item || lpad(new.id_grd_estq, 6, '0'), new.id_grd_estq);
                end if;
            end if;
        end if;
    end if;
    
    return new;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_grd_estq
  ADD COLUMN gera_cd_bar BOOLEAN;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_grd_estq_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        if (tg_op = 'UPDATE') then
            if (new.vl_qtd <> old.vl_qtd) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'S', old.vl_qtd);
            end if;
                
            if (new.vl_qtd <> old.vl_qtd) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'E', new.vl_qtd);
            end if;
        end if;
            
        if (tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'E', new.vl_qtd);
        end if;
        
        if not exists(select 1 
                      from tb_item_cd_bar 
                      where
                          id_item = new.id_item and
                          id_grd_estq = new.id_grd_estq) and
            exists (select 1
                    from tb_grd_estq
                    where
                        id_grd_estq = new.id_grd_estq and
                        gera_cd_bar) then
            insert into tb_item_cd_bar
                (id_item, cd_bar, id_grd_estq)
            values
                (new.id_item, new.id_item || lpad(new.id_grd_estq, 6, '0'), new.id_grd_estq);
        end if;
        
        return new;
    elsif (tg_op = 'DELETE') then
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'S', old.vl_qtd);
    
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_vnd_item
  ADD COLUMN id_vndr INTEGER;

ALTER TABLE public.tb_vnd_item
  ADD CONSTRAINT fk__vnd_item__vndr FOREIGN KEY (id_vndr)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_cd_bar
  ADD CONSTRAINT fk__item_cd_bar__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

