CREATE OR REPLACE FUNCTION public.fc_get_emp_cnf (
  _id_emp integer,
  _id_cnf integer
)
RETURNS varchar AS
$body$
declare
    _result varchar;
BEGIN
    select val into _result
    from tb_est_cnf
    where
        id_est = fc_id_est_local() and
        id_cnf = _id_cnf;

    if found then
        return _result;
    end if;


    select val into _result
    from tb_emp_cnf
    where
        id_emp = _id_emp and
        id_cnf = _id_cnf;
    
    if found then
        return _result;
    else
        return '';
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
    
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    
    _op_fnc record;    
    
    _app_con varchar;
    _nr_doc integer;
    
    _nr_blt_ini integer;
    _nr_blt_fin integer;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and new.tp_doc = 'CH') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, new.id_ct, new.id_part);
        end if;
        
        --
        -- Gera proxima ct contrato
        --
        if (tg_op = 'UPDATE') then
        
            if (new.tp_ct = 'R' and new.stat = 'Q' and old.stat = 'P' and new.org like 'CONTR.%') then
                _aux := regexp_split_to_array(new.org, '\.');
                
                select count(*) into _qtd
                from tb_ct
                where
                    id_emp = new.id_emp and
                    id_part = new.id_part and
                    tp_ct = 'R' and
                    org = new.org and
                    dt_venc > new.dt_venc and
                    id_ct <> new.id_ct;
                
                if (_qtd = 0) then
                    
                    select * into _contr
                    from tb_part_contr
                    where
                        id_emp = new.id_emp and
                        id_part = new.id_part and
                        id_part_contr = cast(_aux[3] as integer);
                
                    if (found) then
                    
                        _dt_venc := fc_calc_venc(new.dt_venc, _contr.tp_interv, _contr.interv);
                        
                        if (_dt_venc <= _contr.dt_f) then
                            _id_cnt_bnc := null;
        
                            if (_contr.tp_doc = 'BLT') then
                                _id_cnt_bnc_str := fc_get_emp_cnf(new.id_emp, 01002);
                                
                                if (_id_cnt_bnc_str <> '') then
                                    _id_cnt_bnc := cast(_id_cnt_bnc_str as integer);
                                end if;
                            end if;
                        
                        
                            insert into tb_ct
                                (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, dt_emis, dt_venc,
                                 vl_ct, obs, stat, tp_doc, org, id_cnt_bnc, id_op_fnc, vl_quit, vl_rest, id_plano_ct)
                            values
                                (_contr.id_emp, nextval('sq_ct'), 'R', _contr.id_part, _contr.doc, new.parc + 1, new.parc + 1, new.dt_venc, _dt_venc,
                                 _contr.vl_contr, _contr.obs, 'P', _contr.tp_doc, new.org, _id_cnt_bnc, _contr.id_op_fnc, 0, _contr.vl_contr, _contr.id_plano_ct);
                        end if;
                    end if;
                end if;
            elsif (new.tp_ct = 'R' and new.stat = 'P' and old.stat = 'Q' and new.org like 'CONTR.%') then
                _aux := regexp_split_to_array(new.org, '\.');
                    
                select * into _contr
                from tb_part_contr
                where
                    id_emp = new.id_emp and
                    id_part = new.id_part and
                    id_part_contr = cast(_aux[3] as integer);
                        
                if (found) then
                    _dt_venc := fc_calc_venc(new.dt_venc, _contr.tp_interv, _contr.interv);
                    
                    delete from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_part = new.id_part and
                        tp_ct = 'R' and
                        org = new.org and
                        dt_venc = _dt_venc and
                        stat = 'P' and
                        id_ct <> new.id_ct;
                end if;
            end if;
        end if;
        
        -- return new;
    elsif (tg_op = 'DELETE') then
        if (old.tp_ct = 'P') and (_app_con <> 'NEO_UNI') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
        end if;
    end if;
    
    --
    -- Sef for boleto gera o numero do boleto
    --
    if (tg_op = 'INSERT' and _app_con <> 'NEO_UNI') then
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'BLT') then
            -- CNF_NR_BLT_INI                    = 01015;
            -- CNF_NR_BLT_FIN                    = 01016;
            
            _nr_blt_ini := cast(coalesce(fc_get_emp_cnf(new.id_emp, 01015), '1') as integer);
            _nr_blt_fin := cast(coalesce(fc_get_emp_cnf(new.id_emp, 01016), '99999') as integer);
            
            select coalesce(max(cast(coalesce(nr_doc, '0') as integer)), _nr_blt_ini -1) + 1 into _nr_doc
            from tb_ct
            where
                id_op_fnc = new.id_op_fnc and
                id_cnt_bnc = new.id_cnt_bnc and
                cast(coalesce(nr_doc, '0') as integer) between _nr_blt_ini and _nr_blt_fin;
            
            if (_nr_doc > _nr_blt_fin) then
                raise exception 'Numeracao de boleto indisponivel: %-%', _nr_blt_ini, _nr_blt_fin;
            end if;
            
            new.nr_doc := cast(_nr_doc as varchar);
        end if;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    else
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;


update tb_ct set
    nr_doc = id_ct
where
    exists (select 1
            from tb_op_fnc
            where
                tb_op_fnc.tp_op_fnc = 'BLT' and
                tb_op_fnc.id_op_fnc = tb_ct.id_op_fnc);