CREATE OR REPLACE FUNCTION public.fc_fec_ped_compl (
  _id_emp integer,
  _id_ped integer,
  _id_dep_org integer,
  _id_dep_dst integer
)
RETURNS boolean AS
$body$
declare
    _ped record;
    _ped_item record;
    _ped_item_list refcursor;
    
    _id_mnt_estq integer;
    _id_mnt_estq_item integer;
    
    _id_grd_estq varchar;
begin

    _id_grd_estq := fc_get_emp_cnf(_id_emp, 08004);
    
    select * into _ped
    from tb_ped
    where
        id_emp = _id_emp and
        id_ped = _id_ped;
    
    delete from tb_mnt_estq
    where
        id_emp = _id_emp and
        org = 'PED.' || _id_ped and
        id_org = _id_ped;
        
        
    _id_mnt_estq := nextval('sq_mnt_estq');
    
    insert into tb_mnt_estq
        (id_emp, id_mnt_estq, dt_mnt_estq, op, id_dep_org, id_dep_dst, descr, org, id_org)
    values
        (_id_emp, _id_mnt_estq, _ped.dt_ped, 'T', _id_dep_org, _id_dep_dst, 'CARREGAMENTO COMPLEMENTAR ' || _id_ped, 'PED.' || _id_ped, _id_ped);
        
    
    open _ped_item_list for
        select
            tb_ped_item.*,
            tb_item.id_und_med as id_und_med_item
        from tb_ped_item
        join tb_item on
            (tb_ped_item.id_item = tb_item.id_item)
        where
            id_emp = _id_emp and
            id_ped = _id_ped;
            
    fetch _ped_item_list into _ped_item;
    
    _id_mnt_estq_item := 0;
    
    while found loop
        
        _id_mnt_estq_item := _id_mnt_estq_item + 1;
    
        insert into tb_mnt_estq_item
            (id_emp, id_mnt_estq, id_mnt_estq_item, id_item, id_grd_estq, id_und_med, vl_qtd, 
             id_und_med_mov, vl_qtd_mov)
        values
            (_id_emp, _id_mnt_estq, _id_mnt_estq_item, _ped_item.id_item, _id_grd_estq, _ped_item.id_und_med_item, _ped_item.vl_qtd, 
             _ped_item.id_und_med_item, _ped_item.vl_qtd);
            
        fetch _ped_item_list into _ped_item;
        
    end loop;
    
    
    update tb_ped set
        sit = 'F'
    where
        id_emp = _id_emp and
        id_ped = _id_ped;
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_fnc_bf (
)
RETURNS trigger AS
$body$
begin
    if ((tg_op = 'UPDATE') and (old.op = 'T')) or (tg_op = 'DELETE') then
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'MOV_FNC.' || old.id_mov_fnc;
                
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'MOV_FNC.' || old.id_mov_fnc;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        if (new.op = 'T') and (new.dst = 'C') and (coalesce(new.id_dst, 0) > 0) then
            insert into tb_mov_fnc
                (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc, 
                 doc, descr, op, vl_lanc, 
                 org, id_org, id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_fnc'), new.id_dst, new.id_usr, new.dt_lanc, new.hr_lanc,
                 new.doc, new.descr, 'C', new.vl_lanc, 'MOV_FNC.' || new.id_mov_fnc, new.id_mov_fnc, new.id_op_fnc);
        end if;
        
        if (new.op = 'T') and (new.dst = 'B') and (coalesce(new.id_dst, 0) > 0) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc,
                 nr_doc, descr, op, vl_lanc, conc,
                 org, id_org)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_dst, new.dt_lanc, new.dt_lanc, 
                 new.doc, new.descr, 'C', new.vl_lanc, false, 'MOV_FNC.' || new.id_mov_fnc, new.id_mov_fnc);
        end if;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_mnt_estq
  ADD COLUMN org VARCHAR(20);

ALTER TABLE public.tb_mnt_estq
  ADD COLUMN id_org INTEGER;
