CREATE OR REPLACE FUNCTION public.fc_app_con (
)
RETURNS varchar AS
$body$
declare
    _app_name varchar;
begin
    select application_name into _app_name
    from pg_stat_activity
    where
        pid = pg_backend_pid();
        
    return _app_name;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_gera_nf_vnd (
  _id_emp integer,
  _id_vnd integer,
  _mod_nf varchar
)
RETURNS boolean AS
$body$
DECLARE
    _vnd record;
    _vnd_item_list refcursor;
    _vnd_item record;
    _vnd_parc_list refcursor;
    _vnd_parc record;
    
    _inf_ad_cont varchar;
    
    _id_nf_parc integer;
    
    _id_nf integer;
    _aux varchar;
    
    _ser_nf integer;
    _num_nf integer;
    _id_mod_nf varchar;
    _id_nat_op integer;
    _nat_op record;
    
    _vl_bc_icms numeric;
    _vl_icms numeric;
    _vl_bc_icms_st numeric;
    _vl_icms_st numeric;
    -- _vl_frete numeric;
    -- _vl_seg numeric;
    _vl_desc numeric;
    _vl_ipi numeric;
    _vl_pis numeric;
    _vl_cofins numeric;
    _vl_out numeric;
    _vl_item numeric;
    _vl_nf numeric;
    
    
    
    _vl_bc_icms_item numeric;
    _vl_aliq_icms_item numeric;
    _vl_icms_item numeric;
    
    _id_trib_ipi_item varchar;
    _vl_bc_ipi_item numeric;
    _vl_aliq_ipi_item numeric;
    _vl_ipi_item numeric;
    
    _vl_bc_pis_item numeric;
    _vl_aliq_pis_item numeric;
    _vl_pis_item numeric;
    
    _vl_bc_cofins_item numeric;
    _vl_aliq_cofins_item numeric;
    _vl_cofins_item numeric;
    
    _vl_bc_icms_st_item numeric;
    _vl_aliq_icms_st_item numeric;
    _vl_icms_st_item numeric;
    
    _vl_tot_trib numeric;
    
    
    _id_nf_item integer;
    _id_cfop integer;
    _und_med_trib record;
    
    _id_und_med_trib varchar;
    _cd_bar_trib varchar;
    _vl_qtd_trib numeric;
    _vl_unt_trib numeric;
    
    _id_reg_trib_item varchar;
BEGIN
    select 
        tb_vnd.*,
        tb_cond_pagto.fm_pagto_nfe,
        emp.id_munic as id_munic_emp,
        munic_emp.id_uf as id_uf_emp,
        munic_dst.id_uf as id_uf_dst
    into _vnd
    from tb_vnd
    left outer join tb_cond_pagto on
        (tb_vnd.id_cond_pagto = tb_cond_pagto.id_cond_pagto)
    join tb_part emp on
        (tb_vnd.id_emp = emp.id_part)
    left outer join tb_munic munic_emp on
        (emp.id_munic = munic_emp.id_munic)
    left outer join tb_munic munic_dst on
        (tb_vnd.id_munic = munic_dst.id_munic)
    where
        tb_vnd.id_emp = _id_emp and
        tb_vnd.id_vnd = _id_vnd;
        
    
    select nextval('sq_nf') into _id_nf;
    
    _inf_ad_cont := '';
    
    if (_mod_nf = 'NFE') then
        select fc_get_emp_cnf(_id_emp, 2003) into _aux;
        select fc_get_emp_cnf(_id_emp, 2001) into _id_mod_nf;
        
        if (_aux = '') then
            raise exception 'Serie para NFe nao definida';
        end if;
        
        _ser_nf := cast(_aux as integer);
        
        select fc_get_emp_cnf(_id_emp, 2002) into _aux;
        
        if (_aux = '') then
            raise exception 'Natureza de operacao para NFe nao definida';
        end if;
        
        _id_nat_op := cast(_aux as integer);
        
    elsif (_mod_nf = 'NF') then
        
        _id_mod_nf := '01';
    
        _ser_nf := 1;
        
        _id_nat_op := _vnd.id_nat_op;
    
    elsif (_mod_nf = 'NFCE') then
        select fc_get_emp_cnf(_id_emp, 3001) into _aux;
        select fc_get_emp_cnf(_id_emp, 3000) into _id_mod_nf;
        
        if (_aux = '') then
            raise exception 'Serie para NFCe nao informada';
        end if;
        
        _ser_nf := cast(_aux as integer);
        
        select fc_get_emp_cnf(_id_emp, 3002) into _aux;
        
        if (_aux = '') then
            raise exception 'Natureza de operacao para NFCe nao definida';
        end if;
        
        _id_nat_op := cast(_aux as integer);
        
        
        _inf_ad_cont := fc_get_emp_cnf(_id_emp, 3005);
    end if;
    
    select * into _nat_op
    from tb_nat_op
    where
        id_nat_op = _id_nat_op;
    
    if (_mod_nf = 'NF') then
        _num_nf := cast(_vnd.cd_ref as integer);
    else
        select fc_get_num_nf(_id_emp, _ser_nf) into _num_nf;
    end if;
    
    insert into tb_nf 
        (id_emp, id_nf, id_mod_nf, tp_emis, ser, num, dt_emis, tp_op, dt_op, hr_op, 
         fm_pagto, fm_emis, fin_emis, tp_imp,
         id_nat_op, id_munic_fg, 
         id_part_dst, cpf_cnpj_dst, nome_dst, insc_dst, email_dst, 
         cep_dst, logr_dst, num_dst, compl_dst, bairro_dst, id_munic_dst, fone_dst,  
         inf_ad_cont, id_vnd)
    values
        (_id_emp, _id_nf, _id_mod_nf, '[P]', _ser_nf, _num_nf, _vnd.dt_vnd, '[S]', current_date, current_time,
         _vnd.fm_pagto_nfe, 'N', 'N', 'R',
         _id_nat_op, _vnd.id_munic_emp,
         _vnd.id_cli, _vnd.cpf_cnpj, _vnd.nome, _vnd.insc, _vnd.email,
         _vnd.cep, _vnd.logr, _vnd.num, _vnd.compl, _vnd.bairro, _vnd.id_munic, _vnd.fone,
         _inf_ad_cont, _vnd.id_vnd);

    if (_mod_nf = 'NFE') then
        update tb_nf set
            num_fat = _vnd.id_vnd,
            vl_fat = _vnd.vl_tot, 
            vl_desc_fat = 0, 
            vl_liq_fat = _vnd.vl_tot
        where
            id_emp = _id_emp and
            id_nf = _id_nf;
    end if;

   
    _vl_bc_icms := 0;
    _vl_icms := 0;
    _vl_bc_icms_st := 0;
    _vl_icms_st := 0;
    _vl_ipi := 0;
    _vl_pis := 0;
    _vl_cofins := 0;
    _vl_desc := 0;
    _vl_out := 0;
    _vl_item := 0;
    _vl_nf := 0;
    _vl_tot_trib := 0;
    

    
    open _vnd_item_list for
        select
            tb_vnd_item.*,
            tb_item.mov_estq,
            tb_item.id_ncm,
            tb_item.cd_bar,
            tb_item.prod_esp,
            tb_item.vl_peso_liq * tb_vnd_item.vl_qtd_mov as vl_peso_liq,
            tb_item.vl_peso_brt * tb_vnd_item.vl_qtd_mov as vl_peso_brt,
            tb_tp_item.item_nf,
            tb_grp_cfop_nat_op.id_cfop_d,
            tb_grp_cfop_nat_op.id_cfop_f,
            tb_grp_trib_nat_op.*,
            (tb_vnd_item.vl_sub_tot * tb_ncm.vl_aliq_nac / 100) as  vl_tot_trib
        from tb_vnd_item
        join tb_item on
            (tb_vnd_item.id_item = tb_item.id_item)
        left outer join tb_grp_trib_nat_op on
            (tb_item.id_grp_trib = tb_grp_trib_nat_op.id_grp_trib and
             tb_grp_trib_nat_op.id_nat_op = _id_nat_op)
        left outer join tb_grp_cfop_nat_op on
            (tb_item.id_grp_cfop = tb_grp_cfop_nat_op.id_grp_cfop and
             tb_grp_cfop_nat_op.id_nat_op = _id_nat_op)
        left outer join tb_tp_item on
            (tb_item.id_tp_item = tb_tp_item.id_tp_item)
        left outer join tb_ncm on
            (tb_item.id_ncm = tb_ncm.id_ncm)
        where
            tb_vnd_item.id_emp = _id_emp and
            tb_vnd_item.id_vnd = _id_vnd;
            


    fetch _vnd_item_list into _vnd_item;
    
    _id_nf_item := 1;
    _id_reg_trib_item := fc_get_emp_cnf(_id_emp, 2000);
    
    while found loop
        if (_vnd_item.item_nf) then
            

            --
            -- Cfop
            --
            if (_mod_nf = 'NFCE') or (_vnd.id_uf_emp = _vnd.id_uf_dst) then
                _id_cfop := _vnd_item.id_cfop_d;
            else
                _id_cfop := _vnd_item.id_cfop_f;
            end if;
            

            
            --
            -- Unidade de medida tributada
            --
            select
                tb_item_und_med.id_und_med,
                tb_item_und_med.vl_conv,
                tb_item_und_med.cd_bar 
            into _und_med_trib
            from tb_item_und_med
            where
                tb_item_und_med.id_item = _vnd_item.id_item and
                tb_item_und_med.op like '%[NF_EMT]%'
            limit 1;
            
            raise notice 'teste 5.3';
            
            if not found then
                raise notice 'teste 5.3.1';
                
                select 
                    tb_item.id_und_med,
                    cast(1 as numeric(12,4)) as vl_conv,
                    tb_item.cd_bar
                into _und_med_trib
                from tb_item
                where
                    tb_item.id_item = _vnd_item.id_item;
            end if;
            
            if (_und_med_trib.id_und_med is null or _und_med_trib.id_und_med = '') then
                raise exception 'Unidade de medida do item "%" nao esta defidina', _vnd_item.id_item;
            end if;
            
            _id_und_med_trib := _und_med_trib.id_und_med;
            _vl_qtd_trib := _vnd_item.vl_qtd_mov * _und_med_trib.vl_conv;
            
            _cd_bar_trib := _und_med_trib.cd_bar;
            
        
            --
            -- Calucla icms, icms st, ipi, pis e cofins
            --
            
            _vl_bc_icms_item   := 0;
            _vl_aliq_icms_item := 0;
            _vl_icms_item      := 0;
            if (_vnd_item.vl_aliq_icms <> 0) then
                _vl_bc_icms_item   := _vnd_item.vl_sub_tot;
                _vl_aliq_icms_item := _vnd_item.vl_aliq_icms;
                _vl_icms_item      := cast(_vnd_item.vl_sub_tot * _vnd_item.vl_aliq_icms / 100 as numeric(12,2));
                
                _vl_bc_icms := _vl_bc_icms + _vl_bc_icms_item;
                _vl_icms := _vl_icms + _vl_icms_item;
            end if;
            

            _id_trib_ipi_item := null;
            _vl_bc_ipi_item   := 0;
            _vl_aliq_ipi_item := 0;
            _vl_ipi_item      := 0;
            if (_mod_nf = 'NFE') then
                _id_trib_ipi_item := _vnd_item.id_trib_ipi;
                if (_vnd_item.vl_aliq_ipi <> 0) then
                    _vl_bc_ipi_item   := _vnd_item.vl_sub_tot;
                    _vl_aliq_ipi_item := _vnd_item.vl_aliq_ipi;
                    _vl_ipi_item      := cast(_vnd_item.vl_sub_tot * _vnd_item.vl_aliq_ipi / 100 as numeric(12,2));
                    
                    _vl_ipi := _vl_ipi + _vl_ipi_item;
                end if;
            end if;
            
            _vl_bc_pis_item   := 0;
            _vl_aliq_pis_item := 0;
            _vl_pis_item      := 0;
            if (_vnd_item.vl_aliq_pis <> 0) then
                if (_vnd_item.id_trib_pis = '03') then
                    _vl_bc_pis_item   := _vl_qtd_trib;
                else
                    _vl_bc_pis_item   := _vnd_item.vl_sub_tot;
                end if;
                _vl_aliq_pis_item := _vnd_item.vl_aliq_pis;
                -- _vl_pis_item      := cast(_vnd_item.vl_sub_tot * _vnd_item.vl_aliq_pis / 100 as numeric(12,2));
                _vl_pis_item      := _vnd_item.vl_sub_tot * _vnd_item.vl_aliq_pis / 100;
                
                _vl_pis := _vl_pis + _vl_pis_item;
            end if;
            
            _vl_bc_cofins_item   := 0;
            _vl_aliq_cofins_item := 0;
            _vl_cofins_item      := 0;
            if (_vnd_item.vl_aliq_cofins <> 0) then
                if (_vnd_item.id_trib_cofins = '03') then
                    _vl_bc_cofins_item   := _vl_qtd_trib;
                else
                    _vl_bc_cofins_item   := _vnd_item.vl_sub_tot;
                end if;
                _vl_aliq_cofins_item := _vnd_item.vl_aliq_cofins;
                --_vl_cofins_item      := cast(_vnd_item.vl_sub_tot * _vnd_item.vl_aliq_cofins / 100 as numeric(12,2));
                _vl_cofins_item      := _vnd_item.vl_sub_tot * _vnd_item.vl_aliq_cofins / 100;
                
                _vl_cofins := _vl_cofins + _vl_cofins_item;
            end if;
            
            _vl_bc_icms_st_item   := 0;
            _vl_aliq_icms_st_item := 0;
            _vl_icms_st_item      := 0;
            /*
             configurar para calcular o valor do icms st pelo cnae
             
            if (_vnd_item.vl_aliq_icms_st <> 0) then
                _vl_bc_icms_st_item   := _vnd_item.vl_tot;
                _vl_aliq_icms_st_item := _vnd_item.vl_aliq_icms_st;
                _vl_icms_st_item      := _vnd_item.vl_tot * _vnd_item.vl_aliq_icms_st / 100;
                
                _vl_bc_icms_st := _vl_bc_icms_st + _vl_bc_icms_st_item;
                _vl_icms_st := _vl_icms_st + _vl_icms_st_item;
            end if;
            */
            
            _vl_desc := cast(_vl_desc + _vnd_item.vl_desc as numeric(12,2));
            _vl_out  := _vl_out + coalesce(_vnd_item.vl_acr, 0);
            
            _vl_item := cast(_vl_item + _vnd_item.vl_sub_tot as numeric(12,2));
                
            _vl_tot_trib := cast(_vl_tot_trib + coalesce(_vnd_item.vl_tot_trib, 0) as numeric(12,2));
            _vl_unt_trib := cast(_vnd_item.vl_sub_tot / _vl_qtd_trib as numeric(12,2));
                
            insert into tb_nf_item
                (id_emp, id_nf, id_nf_item, id_dep, id_grd_estq, id_item, descr_item,
                 id_ncm, id_cfop, 
                 id_und_med_com, cd_bar_com, vl_qtd_com, vl_unt_com,
                 id_und_med_trib, cd_bar_trib, vl_qtd_trib, vl_unt_trib,
                 -- vl_seg, vl_frete, 
                 vl_tot, vl_desc, vl_out, 
                 prod_esp, id_grp_trib, 
                 id_trib_icms, mod_bc_icms, vl_bc_icms, vl_aliq_icms, vl_icms, -- vl_perc_red_bc_icms,
                 mod_bc_icms_st, vl_bc_icms_st, vl_aliq_icms_st, vl_icms_st,
                 id_trib_ipi, vl_bc_ipi, vl_aliq_ipi, vl_ipi,
                 id_trib_pis, vl_bc_pis, vl_aliq_pis, vl_pis,
                 id_trib_cofins, vl_bc_cofins, vl_aliq_cofins, vl_cofins, 
                 vl_peso_liq, vl_peso_brt, id_reg_trib,
                 vl_tot_trib,
                 
                 mov_estq, id_und_med_mov, vl_qtd_mov, tot_nf_item)
            values
                (_id_emp, _id_nf, _id_nf_item, _vnd_item.id_dep, _vnd_item.id_grd_estq, _vnd_item.id_item, _vnd_item.descr,
                 _vnd_item.id_ncm, _id_cfop,
                 _vnd_item.id_und_med, _vnd_item.cd_bar, _vnd_item.vl_qtd, _vnd_item.vl_sub_tot / _vnd_item.vl_qtd,
                 _id_und_med_trib, _cd_bar_trib, _vl_qtd_trib, _vl_unt_trib,
                 _vnd_item.vl_sub_tot, cast(_vnd_item.vl_desc as numeric(12,2)), cast(_vnd_item.vl_acr as numeric(12,2)),
                 _vnd_item.prod_esp, _vnd_item.id_grp_trib,
                 _vnd_item.id_trib_icms, _vnd_item.mod_bc_icms, _vl_bc_icms_item, _vl_aliq_icms_item, _vl_icms_item,
                 _vnd_item.mod_bc_icms_st, _vl_bc_icms_st_item, _vl_aliq_icms_st_item, _vl_icms_st_item,
                 _id_trib_ipi_item, _vl_bc_ipi_item, _vl_aliq_ipi_item, _vl_ipi_item,
                 _vnd_item.id_trib_pis, _vl_bc_pis_item, _vl_aliq_pis_item, _vl_pis_item,
                 _vnd_item.id_trib_cofins, _vl_bc_cofins_item, _vl_aliq_cofins_item, _vl_cofins_item,
                 _vnd_item.vl_peso_liq, _vnd_item.vl_peso_brt, _id_reg_trib_item,
                 cast(_vnd_item.vl_tot_trib as numeric(12,2)),
                 false, _vnd_item.id_und_med_mov, _vnd_item.vl_qtd_mov, true
            );
            
            _id_nf_item := _id_nf_item + 1;
        end if;
        
        fetch _vnd_item_list into _vnd_item;
        
    end loop;
    
    
    close _vnd_item_list;
    
    _vl_nf := _vl_item;
    
    if (position('[ICMS]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + coalesce(_vl_icms, 0);
    end if;
    
    if (position('[ICMS_ST]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + coalesce(_vl_icms_st, 0);
    end if;
    
    -- if (position('[FRETE]' in _nat_op.ap_tot_nf) > 0) then
    --    _vl_nf := _vl_nf + _vl_frete;
    -- end if;
    
    if (position('[IPI]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + coalesce(_vl_ipi, 0);
    end if;
    
    if (position('[PIS]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + cast(coalesce(_vl_pis, 0) as numeric(12,2));
    end if;
    
    if (position('[COFINS]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + cast(coalesce(_vl_cofins, 0) as numeric(12,2));
    end if;
    
    if (position('[DESC]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf - coalesce(_vl_desc, 0);
    end if;
    
    if (position('[OUT]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + coalesce(_vl_out, 0);
    end if;
    
    update tb_nf set
        vl_bc_icms = _vl_bc_icms,
        vl_icms = _vl_icms,
        vl_bc_icms_st = _vl_bc_icms_st,
        vl_icms_st = _vl_icms_st,
        vl_ipi = _vl_ipi,
        vl_pis = _vl_pis,
        vl_cofins = _vl_cofins,
        vl_desc = _vl_desc,
        vl_out = _vl_out,
        vl_item = _vl_item,
        vl_nf = _vl_nf,
        vl_tot_trib = _vl_tot_trib
    where
        id_emp = _id_emp and
        id_nf = _id_nf;

    --
    -- Formas de pagamento NFCe
    --
    if (_mod_nf = 'NFCE') then
        -- _vnd_parc_list refcursor;
        -- _vnd_parc record;    
        
        open _vnd_parc_list for
            select *
            from tb_vnd_parc
            where
                id_emp = _id_emp and
                id_vnd = _id_vnd;
        
        fetch _vnd_parc_list into _vnd_parc;
        
        _id_nf_parc := 1;
        
        while found loop
            insert into tb_nf_parc
                (id_emp, id_nf, id_nf_parc, id_op_fnc,
                 dt_venc, vl_parc, nr_doc, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 nr_parc, qtd_parc)
            values
                (_id_emp, _id_nf, _id_nf_parc, _vnd_parc.id_op_fnc,
                 _vnd_parc.dt_venc, _vnd_parc.vl_parc, _vnd_parc.nr_doc,
                 _vnd_parc.emit, _vnd_parc.cpf_cnpj, _vnd_parc.id_bnc, _vnd_parc.ag, _vnd_parc.cnt,
                 _vnd_parc.nr_parc, _vnd_parc.qtd_parc);

            _id_nf_parc := _id_nf_parc + 1;
            
            fetch _vnd_parc_list into _vnd_parc;
        end loop;
    end if;
    
    
    if (_mod_nf = 'NFE' or _mod_nf = 'NFCE') then
        insert into tb_nfe
            (id_emp, id_nf, sit)
        values
            (_id_emp, _id_nf, '0');
    end if;
  /*       
         
  id_mod_frete, 
  id_part_trp,
  cpf_cnpj_trp,
  nome_trp,
  insc_trp,
  logr_trp,
  id_munic_trp,
  placa_trp,
  vl_peso_liq_trp,
  vl_peso_brt_trp,
  vl_qtd_vol_trp,
  entreg_trp,
  */
  
        
    
    -- fetch _vnd_item_list into _vnd_
            

    return true;    
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_init_est (
  _id_est integer,
  _upd_id boolean
)
RETURNS boolean AS
$body$
declare
    _seq_list refcursor;
    _seq record;
    _est record;
    _id_init integer;
    _cmd varchar;
    _tab record;
    _max_id integer;
begin
    select * into _est
    from tb_est
    where
        id_est = _id_est;
        
    open _seq_list for
        select * 
        from pg_class 
        where
            relkind = 'S';
            
    fetch _seq_list into _seq;
    
    perform fc_en_trg(false, false);
    
    while found loop
        select * into _tab
        from vw_tab_uni
        where
            tablename = replace(_seq.relname, 'sq_', 'tb_');
    
        if (_tab.op = 'S') then
        
            _id_init := _est.seq_inc + _est.id_est;
            
            raise notice '% %', _seq.relname, _id_init;
            
            execute 
                ' select max(' || replace(_seq.relname, 'sq_', 'id_') || ') ' ||
                ' from ' || _tab.tablename ||
                ' where mod(' || replace(_seq.relname, 'sq_', 'id_') || ',' || _est.seq_inc || ') = ' || _est.id_est  
                into _max_id;
            
            if (_max_id is null) then
                _max_id := _id_init;
            else
                _max_id := _max_id + _est.seq_inc;
            end if;
            
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by ' || _est.seq_inc || ' restart with ' || _max_id;
            
            raise notice '%', _cmd;
            
            execute _cmd;
            
            if (_upd_id is null) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = ' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' / ' || 
                    _est.seq_inc;
                
                raise notice '%', _cmd;
                
                execute _cmd;
            elsif (_upd_id) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = (' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' * ' || 
                    _est.seq_inc || ') + ' || _est.id_est;
                
                raise notice '%', _cmd;
                
                execute _cmd;
            end if;
        else
            
            execute ' select max(' || replace(_seq.relname, 'sq_', 'id_') || ') ' || ' from ' || _tab.tablename into _max_id;
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by 1 restart with ' || coalesce(_max_id, '1');

            raise notice '%', _cmd;
            
            execute _cmd;
        
        end if;
    
        fetch _seq_list into _seq;
    end loop;
    
    perform fc_en_trg(true, false);
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_log_all_tab (
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cur refcursor;
begin
    open _cur for
        select fc_log_tab(pg_tables.tablename, _install)
        from pg_tables
        where
            pg_tables.schemaname = 'public';
        
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name,
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
    _log_tab boolean;
begin
    select _tab in (
        'tb_bairro',
        'tb_bnc',
        'tb_cfop',
        'tb_cnae',
        'tb_cnt_bnc',
        'tb_cond_pagto',
        'tb_conv',
        'tb_cx',
        'tb_dep',
        'tb_est',
        'tb_grd_estq',
        'tb_grp_cfop',
        'tb_grp_item',
        'tb_grp_trib',
        'tb_grp_usr',
        'tb_item',
        'tb_item_emp',
        'tb_item_estq',
        'tb_logr',
        'tb_marca',
        'tb_mod_frete',
        'tb_mod_nf',
        'tb_mtv_dev_ch',
        'tb_munic',
        'tb_nat_op',
        'tb_ncm',
        'tb_op_fnc',
        'tb_org_icms',
        'tb_prod_anp',
        'tb_reg_trib',
        'tb_rel',
        'tb_rota',
        'tb_serv',
        'tb_sis_lay',
        'tb_sis_valid',
        'tb_tp_item',
        'tb_trib_cofins',
        'tb_trib_icms',
        'tb_trib_ipi',
        'tb_trib_pis',
        'tb_uf',
        'tb_und_med',
        'tb_usr',
        'tb_ped',
        'tb_mnt_estq',
        'tb_email',
        'tb_mov_bnc',
        'tb_mov_cx',
        'tb_mov_fnc',
        'tb_vnd',
        'tb_part',
        'tb_ct',
        'tb_bx_ct',
        'tb_nf'
    ) into _log_tab;


    if (_log_tab and _install) then
        
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;

        _cmd := 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log after insert or update or delete ' ||
            ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';
            
        execute _cmd;
        
        perform fc_add_col('public.' || _tab, 'dt_hr_ult_alt', 'timestamp');
            
        return true;
        
    else 
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_log (
)
RETURNS trigger AS
$body$
declare
    _pk varchar[];
    _val varchar[];
    _col_list varchar[];
    _val_list varchar[];
    _id_est integer;
    _i integer;
    _idx integer;
    _count integer;
    _aux varchar;
    
    _dt_hr timestamp;
    
    _app_con varchar;
begin
    _app_con := fc_app_con();
    
    if (_app_con = 'NEO_UNI' and tg_table_name <> 'tb_part') then
        return null;
    end if;

    select
        array(
            select 
                cast(c.column_name as varchar)
            from information_schema.table_constraints tc
            join information_schema.constraint_column_usage as ccu using 
                (constraint_schema, constraint_name)
            join information_schema.columns as c on 
                (c.table_schema = tc.constraint_schema and 
                 tc.table_name = c.table_name and 
                 ccu.column_name = c.column_name)
            where 
                constraint_type = 'PRIMARY KEY' and
                tc.table_name = tg_table_name
            )
    into _pk;
    
    select
        array(
            select 
                pg_attribute.attname
            from pg_attribute 
            join pg_class on 
                (pg_attribute.attrelid = pg_class.oid) 
            where 
                pg_attribute.attname not in ('oid', 'tableoid', 'cmax', 'xmax', 'cmin', 'xmin', 'ctid') and 
                pg_class.relname = tg_table_name
            order by
                pg_attribute.attnum
        )
    into _col_list;
    
    
    _id_est := fc_id_est_con();
    
    _count := array_upper(_pk, 1);
    
    for _i in 1.._count loop

        if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using new;
        else
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using old;
        end if;
        
        _val[_i] := _aux;
    end loop;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        _dt_hr := new.dt_hr_ult_alt;
    else
        _dt_hr := current_timestamp;
    end if;
    
    
    insert into tb_log
        (id_log, org, op, col_pk, val_pk, id_est, dt_hr)
    values
        (nextval('sq_log'), tg_table_name, substring(tg_op, 1, 1), _pk, _val, _id_est, _dt_hr);
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_log_af (
)
RETURNS trigger AS
$body$
declare
    _est_list refcursor;
    _est record;
    _id_est_con integer;
    _tab record;
    _app_con varchar;
begin
    if (new.id_est is not null) then
        return null;
    end if;

    _app_con := fc_app_con();
    
    if (fc_id_est_local() = fc_id_est_central() and _app_con = 'NEO_UNI' and new.org = 'tb_part') then
        _id_est_con := fc_id_est_con();
        
        open _est_list for
            select *
            from tb_est
            where
                tb_est.tp_est <> 'C' and
                tb_est.id_est <> _id_est_con;
    elsif (fc_id_est_local() <> fc_id_est_central()) then
        open _est_list for
            select *
            from tb_est
            where
                tb_est.tp_est = 'C';
    else
        open _est_list for
            select *
            from tb_est
            where
                tb_est.tp_est <> 'C';
    end if;
        
    fetch _est_list into _est;
        
    while found loop
        
        insert into tb_log
            (id_log, org, op, col_pk, val_pk, id_est, dt_hr, sit)
        values
            (nextval('sq_log'), new.org, new.op, new.col_pk, new.val_pk, _est.id_est, new.dt_hr, 'P');
            
        fetch _est_list into _est;
        
    end loop;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_item_estq
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_part
  ALTER COLUMN fax TYPE VARCHAR(20);

CREATE TABLE public.tb_sis_uni (
  ord INTEGER, 
  tab VARCHAR(255), 
  det VARCHAR(255), 
  op VARCHAR(10), 
  cmp_bloq VARCHAR(255)
) WITHOUT OIDS;

